/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.runtime.osgi;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.osgi.husky.internal.AbstractConnector;
import org.jboss.osgi.husky.internal.HuskyLogService;
import org.jboss.osgi.husky.runtime.Connector;
import org.jboss.osgi.husky.runtime.osgi.JMXConnectorMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class JMXConnector
extends AbstractConnector
implements JMXConnectorMBean {
    public static ObjectName OBJECT_NAME;
    private LogService log;
    private BundleContext context;

    public JMXConnector(BundleContext context) {
        this.log = new HuskyLogService(context);
        this.context = context;
    }

    public void start() throws Exception {
        ServiceReference sref = this.context.getServiceReference(MBeanServer.class.getName());
        if (sref == null) {
            throw new IllegalStateException("Cannot obtain MBeanServer service");
        }
        Properties props = new Properties();
        props.setProperty("transport", "jmx");
        this.context.registerService(Connector.class.getName(), (Object)this, (Dictionary)props);
        MBeanServer server = (MBeanServer)this.context.getService(sref);
        server.registerMBean(this, OBJECT_NAME);
        this.log.log(3, "JMXConnector registered: " + OBJECT_NAME);
    }

    public void stop() throws Exception {
        MBeanServer server;
        ServiceReference sref = this.context.getServiceReference(MBeanServer.class.getName());
        if (sref != null && (server = (MBeanServer)this.context.getService(sref)).isRegistered(OBJECT_NAME)) {
            server.unregisterMBean(OBJECT_NAME);
        }
    }

    public InputStream process(InputStream reqStream) {
        return super.process(reqStream);
    }

    static {
        try {
            OBJECT_NAME = ObjectName.getInstance("jboss.osgi.husky:service=jmx-connector");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

