/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.runtime.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Properties;
import org.jboss.osgi.husky.internal.AbstractConnector;
import org.jboss.osgi.husky.internal.HuskyLogService;
import org.jboss.osgi.husky.internal.Util;
import org.jboss.osgi.husky.runtime.Connector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;

public class SocketConnector
extends AbstractConnector {
    public static final String PROP_SOCKET_CONNECTOR_HOST = Connector.class.getName().toLowerCase() + ".host";
    public static final String PROP_SOCKET_CONNECTOR_PORT = Connector.class.getName().toLowerCase() + ".port";
    private LogService log;
    private BundleContext context;
    private ServiceRegistration sreg;
    private ListenerThread listenerThread;

    public SocketConnector(BundleContext context) {
        this.log = new HuskyLogService(context);
        this.context = context;
    }

    public static boolean isRemoteConnection(BundleContext context) {
        return SocketConnector.getHost(context) != null && SocketConnector.getPort(context) != null;
    }

    private static String getPort(BundleContext context) {
        String port = context.getProperty(PROP_SOCKET_CONNECTOR_PORT);
        return port;
    }

    private static String getHost(BundleContext context) {
        String host = context.getProperty(PROP_SOCKET_CONNECTOR_HOST);
        return host;
    }

    public void start() throws Exception {
        String host = SocketConnector.getHost(this.context);
        String port = SocketConnector.getPort(this.context);
        Properties props = new Properties();
        props.setProperty("transport", "socket");
        props.setProperty("host", host);
        props.setProperty("port", port);
        this.listenerThread = new ListenerThread(host, new Integer(port));
        this.listenerThread.start();
        this.sreg = this.context.registerService(Connector.class.getName(), (Object)this, (Dictionary)props);
        this.log.log(3, "SocketConnector registered: " + props);
    }

    public void stop() throws Exception {
        if (this.sreg != null) {
            this.sreg.unregister();
        }
        if (this.listenerThread != null) {
            this.listenerThread.stopListener();
        }
    }

    class ListenerThread
    extends Thread {
        private ServerSocket serverSocket;

        public ListenerThread(String host, int port) {
            super("ConnectorThread");
            try {
                this.serverSocket = new ServerSocket();
                this.serverSocket.bind(new InetSocketAddress(host, port));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot create server socket", ex);
            }
        }

        public void stopListener() {
            try {
                SocketConnector.this.log.log(4, "Stop SocketConnector");
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void run() {
            while (!this.serverSocket.isClosed()) {
                Socket socket = null;
                try {
                    SocketConnector.this.log.log(4, "Waiting for connection ...");
                    socket = this.serverSocket.accept();
                    SocketConnector.this.log.log(4, "Connection accepted");
                }
                catch (IOException ex) {
                    if (this.serverSocket.isClosed()) break;
                }
                if (socket == null) continue;
                try {
                    InputStream resStream = SocketConnector.this.process(socket.getInputStream());
                    Util.copyStream(resStream, socket.getOutputStream());
                    socket.close();
                }
                catch (Exception ex) {
                    SocketConnector.this.log.log(2, "Cannot process request", (Throwable)ex);
                }
            }
        }
    }
}

