/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.internal;

// $Id: LocalInvocation.java 91202 2009-07-14 11:34:29Z thomas.diesler@jboss.com $

import java.util.Arrays;

import org.jboss.osgi.husky.Context;
import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.runtime.Connector;
import org.jboss.osgi.husky.runtime.Runner;
import org.jboss.osgi.husky.runtime.junit.JUnitRunner;

/**
 * An 'in-memory' invocation. 
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 16-May-2009
 */
public class LocalInvocation
{
   public Response invoke(Request req) throws Exception
   {
      Connector connector = new LocalConnector();
      connector.addPackageListener(new MatchAllJUnitPackageListener());
      return connector.process(req);
   }

   class LocalConnector extends AbstractConnector
   {
   }

   class MatchAllJUnitPackageListener extends AbstractPackageListener
   {
      public MatchAllJUnitPackageListener()
      {
         super(Arrays.asList(new String[] { "org.jboss.test" }));
      }

      public Context getContext()
      {
         return new BasicContext();
      }

      @Override
      public Runner getRunner()
      {
         return new JUnitRunner();
      }

      @Override
      public Class<?> loadTestClass(String className)
      {
         return Util.loadClass(className);
      }
   }
}
