/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.runtime.osgi;

// $Id: OSGiJUnitRunner.java 90187 2009-06-15 11:28:40Z thomas.diesler@jboss.com $

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.jboss.osgi.husky.Context;
import org.jboss.osgi.husky.runtime.junit.JUnitRunner;
import org.osgi.framework.BundleContext;

/**
 * An extension to the {@link JUnitRunner} that injects the OSGi BundleContext.
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 16-May-2009
 */
public class OSGiJUnitRunner extends JUnitRunner
{
   @Override
   protected void injectField(Field field, Object target, Context context) throws IllegalAccessException
   {
      BundleContext bundleContext = context.getAttachment(BundleContext.class);
      if (field.getType().isAssignableFrom(BundleContext.class))
      {
         field.set(target, bundleContext);
      }
      else
      {
         field.set(target, context);
      }
   }

   @Override
   protected void injectMethod(Method method, Object target, Context context) throws IllegalAccessException, InvocationTargetException
   {
      BundleContext bundleContext = context.getAttachment(BundleContext.class);
      if (method.getParameterTypes()[0].isAssignableFrom(BundleContext.class))
      {
         method.invoke(target, bundleContext);
      }
      else
      {
         method.invoke(target, context);
      }
   }
}
