/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.osgi.husky.Bridge;
import org.jboss.osgi.husky.internal.BasicBridge;
import org.jboss.osgi.husky.internal.Util;

public abstract class BridgeFactory {
    private static Map<Object, Bridge> bridgeCache = new HashMap<Object, Bridge>();

    public static Bridge getBridge() {
        Properties props = System.getProperties();
        return BridgeFactory.getBridgeInternal(null, props);
    }

    public static Bridge getBridge(Object key) {
        Properties props = System.getProperties();
        return BridgeFactory.getBridgeInternal(key, props);
    }

    public static Bridge getBridge(Object key, Properties props) {
        String className = props.getProperty(Bridge.class.getName());
        if (className == null) {
            throw new IllegalStateException("Cannot find property: " + Bridge.class.getName());
        }
        return BridgeFactory.getBridgeInternal(key, props);
    }

    private static Bridge getBridgeInternal(Object key, Properties props) {
        Bridge bridge = bridgeCache.get(key);
        if (bridge == null) {
            String className = props.getProperty(Bridge.class.getName(), BasicBridge.class.getName());
            bridge = (Bridge)Util.loadInstance(className, props);
            if (key != null) {
                bridgeCache.put(key, bridge);
            }
        }
        return bridge;
    }
}

