/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.util.Collections;
import java.util.List;
import org.jboss.osgi.husky.Context;
import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.runtime.PackageListener;
import org.jboss.osgi.husky.runtime.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPackageListener
implements PackageListener {
    private List<String> testPackages;

    public AbstractPackageListener(List<String> packages) {
        if (packages == null) {
            throw new IllegalArgumentException("Invalid test package: " + packages);
        }
        this.testPackages = packages;
    }

    @Override
    public List<String> getPackageNames() {
        return Collections.unmodifiableList(this.testPackages);
    }

    @Override
    public boolean match(Request req) {
        String testClass = req.getClassName();
        for (String testPackage : this.testPackages) {
            if (!testClass.startsWith(testPackage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Response runTests(Request request) throws ClassNotFoundException {
        String testClass = request.getClassName();
        return this.getRunner().runTests(this.getContext(), this.loadTestClass(testClass));
    }

    public abstract Runner getRunner();

    public abstract Context getContext();

    public abstract Class<?> loadTestClass(String var1) throws ClassNotFoundException;

    public String toString() {
        return this.testPackages.toString();
    }
}

