/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.runtime.junit;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.osgi.husky.Context;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.annotation.ProvideContext;
import org.jboss.osgi.husky.runtime.Runner;
import org.jboss.osgi.husky.runtime.junit.JUnitResponse;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitRunner
implements Runner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response runTests(final Context context, final Class<?> testClass) {
        BlockJUnit4ClassRunner runner;
        try {
            this.injectContext(testClass, null, context);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot initialize test case: " + testClass.getName(), ex);
        }
        try {
            runner = new BlockJUnit4ClassRunner(testClass){

                protected Object createTest() throws Exception {
                    Object target = super.createTest();
                    JUnitRunner.this.injectContext(testClass, target, context);
                    return target;
                }
            };
        }
        catch (InitializationError ex) {
            throw new IllegalStateException("Cannot initialize test case: " + testClass.getName(), ex);
        }
        Result result = new Result();
        RunListener listener = result.createListener();
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.addFirstListener(listener);
        try {
            fNotifier.fireTestRunStarted(runner.getDescription());
            runner.run(fNotifier);
            fNotifier.fireTestRunFinished(result);
        }
        finally {
            fNotifier.removeListener(listener);
        }
        JUnitResponse response = new JUnitResponse(result);
        return response;
    }

    @Override
    public void injectContext(Class<?> testClass, Object target, Context context) throws Exception {
        ProvideContext anProvide;
        for (Field field : testClass.getDeclaredFields()) {
            anProvide = field.getAnnotation(ProvideContext.class);
            if (anProvide == null || (field.getModifiers() & 8) == 0 && target == null) continue;
            this.injectField(field, target, context);
        }
        for (AccessibleObject accessibleObject : testClass.getDeclaredMethods()) {
            anProvide = ((Method)accessibleObject).getAnnotation(ProvideContext.class);
            if (anProvide == null || (((Method)accessibleObject).getModifiers() & 8) == 0 && target == null) continue;
            this.injectMethod((Method)accessibleObject, target, context);
        }
    }

    protected void injectMethod(Method method, Object target, Context value) throws IllegalAccessException, InvocationTargetException {
        method.invoke(target, value);
    }

    protected void injectField(Field field, Object target, Context value) throws IllegalAccessException {
        field.set(target, value);
    }
}

