/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.runtime.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.osgi.husky.internal.HuskyLogService;
import org.jboss.osgi.husky.runtime.Connector;
import org.jboss.osgi.husky.runtime.PackageListener;
import org.jboss.osgi.husky.runtime.osgi.OSGiJUnitPackageListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HuskyExtender
implements SynchronousBundleListener {
    public static final String HEADER_TEST_PACKAGE = "Test-Package";
    private BundleContext context;
    private LogService log;

    public HuskyExtender(BundleContext context) {
        this.log = new HuskyLogService(context);
        this.context = context;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle;
        List<String> packages;
        if (event.getType() == 2) {
            Bundle bundle2 = event.getBundle();
            List<String> packages2 = this.getTestPackages(bundle2);
            if (packages2 != null) {
                this.registerPackageListener(bundle2, packages2);
            }
        } else if (event.getType() == 4 && (packages = this.getTestPackages(bundle = event.getBundle())) != null) {
            this.unregisterPackageListener(bundle, packages);
        }
    }

    private void registerPackageListener(Bundle bundle, List<String> packages) {
        ServiceReference[] srefs = null;
        try {
            srefs = this.context.getServiceReferences(Connector.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        if (srefs != null) {
            this.log.log(3, "Register test packages " + packages);
            for (ServiceReference sref : srefs) {
                Connector connector = (Connector)this.context.getService(sref);
                OSGiJUnitPackageListener listener = new OSGiJUnitPackageListener(bundle, packages);
                connector.addPackageListener(listener);
            }
        }
    }

    private void unregisterPackageListener(Bundle bundle, List<String> packages) {
        ServiceReference[] srefs = null;
        try {
            srefs = this.context.getServiceReferences(Connector.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        if (srefs != null) {
            this.log.log(3, "Unregister test packages " + packages);
            for (ServiceReference sref : srefs) {
                Connector connector = (Connector)this.context.getService(sref);
                for (PackageListener listener : new ArrayList<PackageListener>(connector.getPackageListeners())) {
                    List<String> auxNames = listener.getPackageNames();
                    if (!((Object)auxNames).equals(packages)) continue;
                    connector.removePackageListener(listener);
                }
            }
        }
    }

    private List<String> getTestPackages(Bundle bundle) {
        String testPackage = (String)bundle.getHeaders().get(HEADER_TEST_PACKAGE);
        if (testPackage != null) {
            return Arrays.asList(testPackage.split("[,\\s]"));
        }
        return null;
    }
}

