/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.jboss.osgi.husky.Bridge;
import org.jboss.osgi.husky.Failure;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.internal.BasicRequest;
import org.jboss.osgi.husky.internal.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBridge
implements Bridge {
    private Response response;

    @Override
    public void run() {
        String callerFrame = this.getCallerFrame();
        this.run(this.getCallerClass(callerFrame), this.getCallerMethod(callerFrame));
    }

    @Override
    public void run(Class<?> testClass) {
        String callerFrame = this.getCallerFrame();
        this.run(testClass, this.getCallerMethod(callerFrame));
    }

    @Override
    public void run(Class<?> testClass, String testMethod) {
        if (this.response == null) {
            BasicRequest request = new BasicRequest(testClass.getName(), testMethod);
            this.response = this.getInvoker().invoke(request);
        }
        List<Failure> failures = this.response.getFailures();
        for (Failure failure : failures) {
            String failedMethod;
            String failedClass = failure.getClassName();
            if (!failedClass.equals(testClass.getName()) || (failedMethod = failure.getMethodName()) != null && !failedMethod.equals(testMethod)) continue;
            Throwable failureCause = failure.getException();
            if (failureCause instanceof RuntimeException) {
                throw (RuntimeException)failureCause;
            }
            if (failureCause instanceof Error) {
                throw (Error)failureCause;
            }
            AssertionFailedError error = new AssertionFailedError(failure.getMessage());
            error.initCause(failureCause);
            throw error;
        }
    }

    @Override
    public Class<?> getCallerClass() {
        String callerFrame = this.getCallerFrame();
        String className = callerFrame.substring(0, callerFrame.lastIndexOf(46));
        return Util.loadClass(className);
    }

    @Override
    public String getCallerMethod() {
        String callerFrame = this.getCallerFrame();
        return callerFrame.substring(callerFrame.lastIndexOf(46) + 1);
    }

    @Override
    public String getCallerFrame() {
        String callerFrame = null;
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            try {
                BufferedReader br = new BufferedReader(new StringReader(sw.toString()));
                String line = br.readLine();
                line = br.readLine().trim();
                String bridgePackage = Bridge.class.getPackage().getName();
                while (line.startsWith("at " + bridgePackage)) {
                    line = br.readLine().trim();
                }
                callerFrame = line.substring(3, line.indexOf(40));
            }
            catch (IOException ioex) {
                // empty catch block
            }
            return callerFrame;
        }
    }

    private Class<?> getCallerClass(String callerFrame) {
        String className = callerFrame.substring(0, callerFrame.lastIndexOf(46));
        return Util.loadClass(className);
    }

    private String getCallerMethod(String callerFrame) {
        return callerFrame.substring(callerFrame.lastIndexOf(46) + 1);
    }
}

