/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.osgi.husky.Invoker;
import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.internal.JMXInvocation;
import org.jboss.osgi.husky.internal.SocketInvocation;

public class OSGiInvoker
implements Invoker {
    public Response invoke(Request req) {
        try {
            MBeanServerConnection server = this.getMBeanServer();
            if (SocketInvocation.isRemoteConnection()) {
                return new SocketInvocation().invoke(req);
            }
            return new JMXInvocation().invoke(server, req);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot invoke connector", ex);
        }
    }

    private MBeanServerConnection getMBeanServer() {
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            throw new IllegalStateException("Multiple MBeanServer instances not supported");
        }
        MBeanServer server = null;
        if (serverArr.size() == 1) {
            server = serverArr.get(0);
        }
        if (server == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        return server;
    }
}

