/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.runtime.osgi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.osgi.husky.internal.AbstractConnector;
import org.jboss.osgi.husky.runtime.Connector;
import org.jboss.osgi.husky.runtime.osgi.JMXConnectorMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConnector
extends AbstractConnector
implements JMXConnectorMBean {
    private Logger log = LoggerFactory.getLogger(JMXConnector.class);
    public static ObjectName OBJECT_NAME;

    public JMXConnector(BundleContext context) {
        super(context);
    }

    public void start() throws Exception {
        super.start();
        MBeanServer mbeanServer = this.getMBeanServer();
        mbeanServer.registerMBean(this, OBJECT_NAME);
        Properties props = new Properties();
        props.setProperty("transport", "jmx");
        this.getBundleContext().registerService(Connector.class.getName(), (Object)this, (Dictionary)props);
        this.log.info("JMXConnector registered: " + OBJECT_NAME);
    }

    public void stop() throws Exception {
        super.stop();
        MBeanServer mbeanServer = this.getMBeanServer();
        if (mbeanServer.isRegistered(OBJECT_NAME)) {
            mbeanServer.unregisterMBean(OBJECT_NAME);
        }
    }

    public InputStream process(InputStream reqStream) {
        return super.process(reqStream);
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mbeanServer = null;
        BundleContext context = this.getBundleContext();
        ServiceReference sref = context.getServiceReference(MBeanServer.class.getName());
        if (sref != null) {
            mbeanServer = (MBeanServer)context.getService(sref);
            this.log.debug("Found MBeanServer fom service: " + mbeanServer.getDefaultDomain());
        } else {
            ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
            if (serverArr.size() > 1) {
                this.log.warn("Multiple MBeanServer instances: " + serverArr);
            }
            if (serverArr.size() > 0) {
                mbeanServer = serverArr.get(0);
                this.log.debug("Found MBeanServer: " + mbeanServer.getDefaultDomain());
            }
            if (mbeanServer == null) {
                this.log.debug("No MBeanServer, create one ...");
                mbeanServer = MBeanServerFactory.createMBeanServer();
            }
        }
        return mbeanServer;
    }

    static {
        try {
            OBJECT_NAME = ObjectName.getInstance("jboss.osgi.husky:service=jmx-connector");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

