/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.runtime.osgi;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.jboss.osgi.husky.PackageListener;
import org.jboss.osgi.husky.runtime.osgi.OSGiJUnitPackageListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestProcessor {
    private Logger log = LoggerFactory.getLogger(ManifestProcessor.class);
    public static final String HEADER_TEST_PACKAGE = "Test-Package";
    private BundleContext context;

    public ManifestProcessor(BundleContext context) {
        this.context = context;
    }

    public void registerPackageListener(Bundle bundle, List<String> packages) {
        ServiceReference[] srefs = null;
        try {
            String filter = "(bundle=" + bundle.getSymbolicName() + ")";
            srefs = this.context.getServiceReferences(PackageListener.class.getName(), filter);
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        if (srefs == null) {
            this.log.info("Register test packages " + packages);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("bundle", bundle.getSymbolicName());
            OSGiJUnitPackageListener listener = new OSGiJUnitPackageListener(bundle, packages);
            bundle.getBundleContext().registerService(PackageListener.class.getName(), (Object)listener, properties);
        }
    }

    public List<String> getTestPackages(Bundle bundle) {
        String testPackage = (String)bundle.getHeaders().get(HEADER_TEST_PACKAGE);
        if (testPackage != null) {
            return Arrays.asList(testPackage.split("[,\\s]"));
        }
        return null;
    }
}

