/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.File;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.osgi.testing.OSGiRuntime;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.junit.After;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OSGiTest {
    final Logger log = LoggerFactory.getLogger(OSGiTest.class);
    private OSGiTestHelper helper;

    protected OSGiTest() {
        VFS.init();
    }

    protected OSGiTestHelper getTestHelper() {
        if (this.helper == null) {
            this.helper = new OSGiTestHelper();
        }
        return this.helper;
    }

    @Before
    public void setUp() throws Exception {
        this.log.debug("### START " + this.getLongName());
    }

    @After
    public void tearDown() throws Exception {
        this.log.debug("### END " + this.getLongName());
    }

    protected String getShortName() {
        String shortName = this.getClass().getName();
        shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        return shortName;
    }

    protected String getLongName() {
        return this.getClass().getName();
    }

    protected OSGiRuntime getDefaultRuntime() {
        return this.getTestHelper().getDefaultRuntime();
    }

    protected OSGiRuntime getEmbeddedRuntime() {
        return this.getTestHelper().getEmbeddedRuntime();
    }

    public OSGiRuntime getRemoteRuntime() {
        return this.getTestHelper().getRemoteRuntime();
    }

    protected URL getResourceURL(String resource) {
        return this.getTestHelper().getResourceURL(resource);
    }

    protected File getResourceFile(String resource) {
        return this.getTestHelper().getResourceFile(resource);
    }

    protected URL getTestArchiveURL(String archive) {
        return this.getTestHelper().getTestArchiveURL(archive);
    }

    protected String getTestArchivePath(String archive) {
        return this.getTestHelper().getTestArchivePath(archive);
    }

    protected File getTestArchiveFile(String archive) {
        return this.getTestHelper().getTestArchiveFile(archive);
    }

    public InitialContext getInitialContext() throws NamingException {
        return this.getTestHelper().getInitialContext();
    }

    public String getServerHost() {
        return this.getTestHelper().getServerHost();
    }

    public String getTargetContainer() {
        return this.getTestHelper().getTargetContainer();
    }

    public String getFrameworkName() {
        return this.getTestHelper().getFrameworkName();
    }

    public VirtualFile assembleBundle(String name, String resource, Class<?> ... packages) throws Exception {
        return this.getTestHelper().assembleBundle(name, resource, packages);
    }

    public VirtualFile assembleBundle(String name, String[] resources, Class<?> ... packages) throws Exception {
        return this.getTestHelper().assembleBundle(name, resources, packages);
    }

    public void assertBundleState(int expState, int wasState) {
        this.getTestHelper().assertBundleState(expState, wasState);
    }

    public void assertBundleLoadClass(Bundle bundle, String expClazz, boolean success) {
        this.getTestHelper().assertBundleLoadClass(bundle, expClazz, success);
    }
}

