/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.AssertionFailedError;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.jboss.osgi.testing.OSGiRuntime;
import org.jboss.osgi.testing.internal.EmbeddedRuntime;
import org.jboss.osgi.testing.internal.RemoteRuntime;
import org.jboss.virtual.AssembledDirectory;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.junit.Assert;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiTestHelper {
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private OSGiBootstrapProvider bootProvider;
    private boolean skipCreateBootstrapProvider;
    private static String testResourcesDir;
    private static String testArchiveDir;

    public OSGiTestHelper() {
        testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY, "target/test-classes");
        testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY, "target/test-libs");
    }

    public OSGiBootstrapProvider getBootstrapProvider() {
        if (this.bootProvider == null && !this.skipCreateBootstrapProvider) {
            try {
                this.bootProvider = OSGiBootstrap.getBootstrapProvider();
            }
            catch (RuntimeException rte) {
                this.skipCreateBootstrapProvider = true;
                throw rte;
            }
        }
        return this.bootProvider;
    }

    public void ungetBootstrapProvider() {
        this.bootProvider = null;
    }

    public OSGiRuntime getDefaultRuntime() {
        String target = System.getProperty("target.container");
        OSGiRuntime runtime = target == null ? this.getEmbeddedRuntime() : this.getRemoteRuntime();
        return runtime;
    }

    public OSGiRuntime getEmbeddedRuntime() {
        return new EmbeddedRuntime(this);
    }

    public OSGiRuntime getRemoteRuntime() {
        return new RemoteRuntime(this);
    }

    public URL getResourceURL(String resource) {
        URL resURL = null;
        try {
            File resourceFile = this.getResourceFile(resource);
            resURL = resourceFile.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resURL;
    }

    public File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(testResourcesDir + "/" + resource);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + testResourcesDir + "/" + resource + "'");
    }

    public URL getTestArchiveURL(String archive) {
        try {
            return this.getTestArchiveFile(archive).toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getTestArchivePath(String archive) {
        return this.getTestArchiveFile(archive).getAbsolutePath();
    }

    public File getTestArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(testArchiveDir + "/" + archive);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + testArchiveDir + "/" + archive + "'.");
    }

    public InitialContext getInitialContext() throws NamingException {
        String port = System.getProperty("jndi.server.port", "1099");
        Integer jndiPort = new Integer(port);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        env.put("java.naming.provider.url", "jnp://" + this.getServerHost() + ":" + jndiPort);
        return new InitialContext(env);
    }

    public String getServerHost() {
        String bindAddress = System.getProperty("jboss.bind.address", "localhost");
        return bindAddress;
    }

    public String getTargetContainer() {
        String targetContainer = System.getProperty("target.container");
        return targetContainer;
    }

    public String getFrameworkName() {
        String framework = System.getProperty("framework");
        if (framework == null || framework.length() == 0 || framework.equals("${framework}")) {
            framework = "jbossmc";
        }
        return framework;
    }

    public VirtualFile assembleBundle(String name, String resource, Class<?> ... packages) throws Exception {
        return this.assembleBundle(name, new String[]{resource}, packages);
    }

    public VirtualFile assembleBundle(String name, String[] resources, Class<?> ... packages) throws Exception {
        AssembledDirectory assembledDirectory = AssembledDirectory.createAssembledDirectory((String)name, (String)"");
        for (String path : resources) {
            this.addPath(assembledDirectory, path, "");
        }
        for (Class<?> reference : packages) {
            this.addPackage(assembledDirectory, reference);
        }
        return assembledDirectory;
    }

    public void assertBundleState(int expState, int wasState) {
        String expstr = ConstantsHelper.bundleState((int)expState);
        String wasstr = ConstantsHelper.bundleState((int)wasState);
        Assert.assertEquals((String)("Bundle " + expstr), (Object)expstr, (Object)wasstr);
    }

    public void assertBundleLoadClass(Bundle bundle, String expClazz, boolean success) {
        block4: {
            String message = bundle.getSymbolicName() + " loads " + expClazz;
            try {
                Class wasClass = bundle.loadClass(expClazz);
                if (success) {
                    Assert.assertEquals((String)message, (Object)expClazz, (Object)wasClass.getName());
                } else {
                    Assert.fail((String)("ClassNotFoundException expected for: " + message + "\nLoaded from " + wasClass.getClassLoader()));
                }
            }
            catch (ClassNotFoundException ex) {
                if (!success) break block4;
                Assert.fail((String)("Unexpected ClassNotFoundException for: " + message));
            }
        }
    }

    private void addPath(AssembledDirectory dir, String path, String name) throws Exception {
        URL url = this.getClass().getResource(path);
        if (url == null) {
            throw new AssertionFailedError(path + " not found");
        }
        VirtualFile file = VFS.getVirtualFile((URL)url, (String)name);
        dir.addPath(file);
    }

    private void addPackage(AssembledDirectory dir, Class<?> reference) throws Exception {
        String packagePath = this.packageNameToPath(reference.getName());
        dir.addResources(reference, new String[]{packagePath + "/*.class"}, new String[0]);
    }

    private String packageNameToPath(String className) {
        int end = className.lastIndexOf(46);
        if (end == -1) {
            return "";
        }
        String packageName = className.substring(0, end);
        return packageName.replace('.', '/');
    }
}

