/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.net.URL;
import java.util.Arrays;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.jboss.osgi.deployment.deployer.AbstractDeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.testing.OSGiRuntime;
import org.osgi.framework.BundleException;

class DeployerServiceClient
extends AbstractDeployerService {
    private final OSGiRuntime runtime;
    private ObjectName oname;

    DeployerServiceClient(OSGiRuntime runtime, ObjectName oname) {
        this.runtime = runtime;
        this.oname = oname;
    }

    public void deploy(Deployment[] deps) throws BundleException {
        this.invokeDeployerMBean(this.oname, "deploy", deps, Deployment[].class.getName());
    }

    public void deploy(URL url) throws BundleException {
        this.invokeDeployerMBean(this.oname, "deploy", url, URL.class.getName());
    }

    public void undeploy(Deployment[] deps) throws BundleException {
        this.invokeDeployerMBean(this.oname, "undeploy", deps, Deployment[].class.getName());
    }

    public void undeploy(URL url) throws BundleException {
        this.invokeDeployerMBean(this.oname, "undeploy", url, URL.class.getName());
    }

    private void invokeDeployerMBean(ObjectName oname, String method, Object arg, String type) throws BundleException {
        try {
            this.runtime.getMBeanServer().invoke(oname, method, new Object[]{arg}, new String[]{type});
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            if (ex instanceof MBeanException && (ex = ((MBeanException)ex).getTargetException()) instanceof BundleException) {
                throw (BundleException)ex;
            }
            if (arg instanceof Deployment[]) {
                arg = Arrays.asList((Deployment[])arg);
            }
            throw new BundleException("Cannot " + method + ": " + arg, (Throwable)ex);
        }
    }
}

