/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.spi.util.ExportedPackageHelper;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.internal.EmbeddedRuntime;
import org.jboss.osgi.testing.internal.OSGiBundleImpl;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedBundle
extends OSGiBundleImpl {
    private final Logger log = LoggerFactory.getLogger(EmbeddedBundle.class);
    private Bundle bundle;

    public EmbeddedBundle(OSGiRuntimeImpl runtime, Bundle bundle) {
        super(runtime);
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public int getState() {
        return this.bundle.getState();
    }

    @Override
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public Version getVersion() {
        return this.bundle.getVersion();
    }

    @Override
    public String getLocation() {
        return this.bundle.getLocation();
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.bundle.getHeaders();
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        return this.bundle.getHeaders(locale);
    }

    @Override
    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    @Override
    public String getProperty(String key) {
        return this.bundle.getBundleContext().getProperty(key);
    }

    @Override
    public URL getEntry(String path) {
        return this.bundle.getEntry(path);
    }

    @Override
    public URL getResource(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    public File getDataFile(String filename) {
        return this.bundle.getBundleContext().getDataFile(filename);
    }

    @Override
    public OSGiBundle loadClass(String name) throws ClassNotFoundException {
        Class clazz = this.bundle.loadClass(name);
        Bundle providerBundle = this.getPackageAdmin().getBundle(clazz);
        if (providerBundle == null) {
            return null;
        }
        return this.getRuntime().getBundle(providerBundle.getBundleId());
    }

    @Override
    public void start() throws BundleException {
        this.bundle.start();
        ExportedPackageHelper helper = new ExportedPackageHelper(this.bundle.getBundleContext());
        helper.logExportedPackages(this.bundle);
    }

    @Override
    public void stop() throws BundleException {
        this.bundle.stop();
    }

    @Override
    public void uninstall() throws BundleException {
        this.assertNotUninstalled();
        try {
            BundleContext context = ((EmbeddedRuntime)this.getRuntime()).getSystemContext();
            ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
            if (sref != null) {
                DeployerService service = (DeployerService)context.getService(sref);
                service.undeploy(new URL(this.getLocation()));
            } else {
                this.bundle.uninstall();
            }
            OSGiRuntimeImpl runtimeImpl = (OSGiRuntimeImpl)this.getRuntime();
            runtimeImpl.unregisterBundle(this);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            this.log.error("Cannot uninstall: " + this.getLocation(), (Throwable)ex);
        }
    }

    private PackageAdmin getPackageAdmin() {
        BundleContext context = ((EmbeddedRuntime)this.getRuntime()).getSystemContext();
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        return (PackageAdmin)context.getService(sref);
    }
}

