/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiPackageAdmin;
import org.jboss.osgi.testing.OSGiServiceReference;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.testing.internal.EmbeddedBundle;
import org.jboss.osgi.testing.internal.EmbeddedPackageAdmin;
import org.jboss.osgi.testing.internal.EmbeddedServiceReference;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.service.packageadmin.PackageAdmin;

public class EmbeddedRuntime
extends OSGiRuntimeImpl {
    public EmbeddedRuntime(OSGiTestHelper helper) {
        super(helper);
    }

    public OSGiBundle installBundle(String location) throws BundleException {
        OSGiBundle bundle;
        BundleInfo info = BundleInfo.createBundleInfo((String)location);
        Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
        String symbolicName = info.getSymbolicName();
        Version version = info.getVersion();
        BundleContext context = this.getSystemContext();
        ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
        if (sref != null) {
            DeployerService service = (DeployerService)context.getService(sref);
            this.log.debug("Install using DeployerService: " + service.getClass().getName());
            service.deploy(new Deployment[]{dep});
            bundle = this.getBundle(symbolicName, version, true);
        } else {
            this.log.debug("Install using system context");
            Bundle auxBundle = context.installBundle(info.getLocation());
            bundle = new EmbeddedBundle(this, auxBundle);
        }
        return this.registerBundle(((OSGiBundle)bundle).getLocation(), bundle);
    }

    public OSGiBundle[] getBundles() {
        ArrayList<EmbeddedBundle> absBundles = new ArrayList<EmbeddedBundle>();
        for (Bundle bundle : this.getSystemContext().getBundles()) {
            absBundles.add(new EmbeddedBundle(this, bundle));
        }
        OSGiBundle[] bundleArr = new OSGiBundle[absBundles.size()];
        absBundles.toArray(bundleArr);
        return bundleArr;
    }

    public OSGiBundle getBundle(long bundleId) {
        Bundle bundle = this.getSystemContext().getBundle(bundleId);
        return bundle != null ? new EmbeddedBundle(this, bundle) : null;
    }

    public OSGiServiceReference getServiceReference(String clazz) {
        ServiceReference sref = this.getSystemContext().getServiceReference(clazz);
        return sref != null ? new EmbeddedServiceReference(sref) : null;
    }

    public OSGiServiceReference[] getServiceReferences(String clazz, String filter) {
        ServiceReference[] srefs;
        OSGiServiceReference[] retRefs = null;
        try {
            srefs = this.getSystemContext().getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter syntax: " + filter);
        }
        if (srefs != null) {
            retRefs = new OSGiServiceReference[srefs.length];
            for (int i = 0; i < srefs.length; ++i) {
                retRefs[i] = new EmbeddedServiceReference(srefs[i]);
            }
        }
        return retRefs;
    }

    public void addCapability(Capability capability) throws BundleException {
        Map props = capability.getSystemProperties();
        for (Map.Entry entry : props.entrySet()) {
            String value = System.getProperty((String)entry.getKey());
            if (value != null) continue;
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        super.addCapability(capability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        if (bootProvider != null) {
            super.shutdown();
            try {
                Framework framework = bootProvider.getFramework();
                this.log.debug("Framework stop: " + framework);
                framework.stop();
                framework.waitForStop(5000L);
            }
            catch (Exception ex) {
                this.log.error("Cannot stop the framework", (Throwable)ex);
            }
            finally {
                this.getTestHelper().ungetBootstrapProvider();
            }
        }
    }

    public MBeanServerConnection getMBeanServer() {
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            throw new IllegalStateException("Multiple MBeanServer instances not supported");
        }
        MBeanServer server = null;
        if (serverArr.size() == 1) {
            server = serverArr.get(0);
        }
        if (server == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        return server;
    }

    public OSGiPackageAdmin getPackageAdmin() {
        BundleContext context = this.getSystemContext();
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packAdmin = (PackageAdmin)context.getService(sref);
        return new EmbeddedPackageAdmin(packAdmin);
    }

    public boolean isRemoteRuntime() {
        return false;
    }

    BundleContext getSystemContext() {
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        Framework framework = bootProvider.getFramework();
        if (framework.getState() != 32) {
            try {
                this.log.debug("Framework start: " + framework);
                framework.start();
            }
            catch (BundleException ex) {
                throw new IllegalStateException("Cannot start framework", ex);
            }
        }
        return framework.getBundleContext();
    }
}

