/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiRuntime;
import org.jboss.osgi.testing.OSGiServiceReference;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.testing.internal.DeployerServiceClient;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OSGiRuntimeImpl
implements OSGiRuntime {
    final Logger log = LoggerFactory.getLogger(OSGiRuntimeImpl.class);
    private OSGiTestHelper helper;
    private Map<String, OSGiBundle> bundles = new LinkedHashMap<String, OSGiBundle>();
    private List<Capability> capabilities = new ArrayList<Capability>();

    public OSGiRuntimeImpl(OSGiTestHelper helper) {
        this.helper = helper;
    }

    public OSGiTestHelper getTestHelper() {
        return this.helper;
    }

    public void addCapability(Capability capability) throws BundleException {
        for (Capability dependency : capability.getDependencies()) {
            this.addCapability(dependency);
        }
        OSGiServiceReference[] srefs = null;
        String serviceName = capability.getServiceName();
        if (serviceName != null) {
            srefs = this.getServiceReferences(serviceName, capability.getFilter());
        }
        if (srefs == null || srefs.length == 0) {
            this.log.debug("Add capability: " + capability);
            ArrayList<OSGiBundle> installed = new ArrayList<OSGiBundle>();
            for (BundleInfo info : capability.getBundles()) {
                String location = info.getLocation();
                String symName = info.getSymbolicName();
                Version version = info.getVersion();
                if (this.bundles.get(location) == null && this.getBundle(symName, version) == null) {
                    OSGiBundle bundle = this.installBundle(location);
                    installed.add(bundle);
                    continue;
                }
                this.log.debug("Skip bundle: " + location);
            }
            for (OSGiBundle bundle : installed) {
                bundle.start();
            }
            this.capabilities.add(capability);
        } else {
            this.log.debug("Skip capability: " + capability);
        }
    }

    public void removeCapability(Capability capability) {
        if (this.capabilities.remove(capability)) {
            this.log.debug("Remove capability : " + capability);
            ArrayList bundleInfos = new ArrayList(capability.getBundles());
            Collections.reverse(bundleInfos);
            for (BundleInfo info : bundleInfos) {
                this.failsafeUninstall(this.bundles.remove(info.getLocation()));
            }
        }
        ArrayList dependencies = new ArrayList(capability.getDependencies());
        Collections.reverse(dependencies);
        for (Capability dependency : dependencies) {
            this.removeCapability(dependency);
        }
    }

    public void shutdown() {
        this.log.debug("Start Shutdown");
        ArrayList<String> locations = new ArrayList<String>(this.bundles.keySet());
        Collections.reverse(locations);
        while (locations.size() > 0) {
            String location = locations.remove(0);
            this.failsafeUninstall(this.bundles.remove(location));
        }
        Collections.reverse(this.capabilities);
        while (this.capabilities.size() > 0) {
            Capability capability = this.capabilities.get(0);
            this.removeCapability(capability);
        }
        this.log.debug("End Shutdown");
    }

    void deploy(URL archiveURL) throws Exception {
        DeployerServiceClient deployer = new DeployerServiceClient(this, DeployerService.MBEAN_DEPLOYER_SERVICE);
        deployer.deploy(archiveURL);
    }

    void undeploy(URL archiveURL) throws Exception {
        DeployerServiceClient deployer = new DeployerServiceClient(this, DeployerService.MBEAN_DEPLOYER_SERVICE);
        deployer.undeploy(archiveURL);
    }

    public InitialContext getInitialContext() throws NamingException {
        return this.helper.getInitialContext();
    }

    public String getServerHost() {
        return this.helper.getServerHost();
    }

    public OSGiBundle getBundle(String symbolicName, Version version) {
        OSGiBundle bundle = this.getBundle(symbolicName, version, false);
        return bundle;
    }

    public OSGiServiceReference getServiceReference(String clazz, long timeout) {
        int fraktion = 200;
        timeout /= (long)fraktion;
        OSGiServiceReference sref = this.getServiceReference(clazz);
        while (sref == null && 0L < timeout--) {
            try {
                Thread.sleep(fraktion);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            sref = this.getServiceReference(clazz);
        }
        return sref;
    }

    OSGiBundle getBundle(String symbolicName, Version version, boolean mustExist) {
        OSGiBundle bundle = null;
        List<OSGiBundle> bundles = Arrays.asList(this.getBundles());
        for (OSGiBundle aux : bundles) {
            if (!aux.getSymbolicName().equals(symbolicName) || version != null && !version.equals((Object)aux.getVersion())) continue;
            bundle = aux;
            break;
        }
        if (bundle == null && mustExist) {
            throw new IllegalStateException("Cannot obtain bundle: " + symbolicName + "-" + version + ". We have " + bundles);
        }
        return bundle;
    }

    String getManifestEntry(String location, String key) {
        Manifest manifest = this.getManifest(location);
        Attributes attribs = manifest.getMainAttributes();
        String value = attribs.getValue(key);
        return value;
    }

    private Manifest getManifest(String location) {
        Manifest manifest;
        try {
            File archiveFile = this.getTestHelper().getTestArchiveFile(location);
            JarFile jarFile = new JarFile(archiveFile);
            manifest = jarFile.getManifest();
            jarFile.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot get manifest from: " + location);
        }
        return manifest;
    }

    OSGiBundle registerBundle(String location, OSGiBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot register null bundle for: " + location);
        }
        this.bundles.put(location, bundle);
        return bundle;
    }

    void unregisterBundle(OSGiBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot unregister null bundle");
        }
        if (this.bundles.containsValue(bundle)) {
            Set<Map.Entry<String, OSGiBundle>> entrySet = this.bundles.entrySet();
            for (Map.Entry<String, OSGiBundle> entry : entrySet) {
                if (!bundle.equals(entry.getValue())) continue;
                String key = entry.getKey();
                this.bundles.remove(key);
                break;
            }
        }
    }

    private void failsafeUninstall(OSGiBundle bundle) {
        if (bundle != null) {
            try {
                if (bundle.getState() != 1) {
                    bundle.uninstall();
                }
            }
            catch (Exception ex) {
                this.log.warn("Cannot uninstall bundle: " + bundle, (Throwable)ex);
            }
        }
    }
}

