/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Dictionary;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.spi.util.UnmodifiableDictionary;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.internal.OSGiBundleImpl;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBundle
extends OSGiBundleImpl {
    private final Logger log = LoggerFactory.getLogger(RemoteBundle.class);
    private ManagedBundleMBean bundle;
    private String location;
    private long bundleId;
    private String symbolicName;
    private ObjectName objectName;
    private Dictionary<String, String> defaultHeaders;
    private Dictionary<String, String> rawHeaders;
    private Version version;
    boolean uninstalled;

    public RemoteBundle(OSGiRuntimeImpl runtime, ManagedBundleMBean bundle, BundleInfo info) {
        this(runtime, bundle);
        this.location = info.getLocation();
    }

    public RemoteBundle(OSGiRuntimeImpl runtime, ManagedBundleMBean bundle) {
        super(runtime);
        this.bundle = bundle;
        this.bundleId = bundle.getBundleId();
        this.symbolicName = bundle.getSymbolicName();
        this.objectName = bundle.getObjectName();
        this.location = bundle.getLocation();
        this.defaultHeaders = bundle.getHeaders(null);
        this.rawHeaders = bundle.getHeaders("");
        String versionStr = this.defaultHeaders.get("Bundle-Version");
        this.version = Version.parseVersion((String)versionStr);
    }

    @Override
    public int getState() {
        if (this.uninstalled) {
            return 1;
        }
        try {
            return this.bundle.getState();
        }
        catch (RuntimeException rte) {
            Throwable cause;
            Throwable throwable = cause = rte.getCause() != null ? rte.getCause() : rte;
            if (!(cause instanceof InstanceNotFoundException)) {
                this.log.warn("Cannot get state for: " + this.objectName, cause);
            }
            return 1;
        }
    }

    @Override
    public long getBundleId() {
        return this.bundleId;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return new UnmodifiableDictionary(this.defaultHeaders);
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (locale == null) {
            return new UnmodifiableDictionary(this.defaultHeaders);
        }
        if (locale.length() == 0) {
            return new UnmodifiableDictionary(this.rawHeaders);
        }
        return this.bundle.getHeaders(locale);
    }

    @Override
    public String getProperty(String key) {
        this.assertNotUninstalled();
        return this.bundle.getProperty(key);
    }

    @Override
    public URL getEntry(String path) {
        this.assertNotUninstalled();
        return this.toURL(this.bundle.getEntry(path), null);
    }

    @Override
    public URL getResource(String name) {
        this.assertNotUninstalled();
        return this.toURL(this.bundle.getResource(name), null);
    }

    @Override
    public File getDataFile(String filename) {
        this.assertNotUninstalled();
        return this.bundle.getDataFile(filename);
    }

    @Override
    public OSGiBundle loadClass(String name) throws ClassNotFoundException {
        this.assertNotUninstalled();
        ObjectName providerBundle = this.bundle.loadClass(name);
        if (providerBundle == null) {
            return null;
        }
        String bundleId = providerBundle.getKeyProperty("id");
        return this.getRuntime().getBundle(new Long(bundleId));
    }

    @Override
    public void start() throws BundleException {
        this.assertNotUninstalled();
        this.bundle.start();
    }

    @Override
    public void stop() throws BundleException {
        this.assertNotUninstalled();
        this.bundle.stop();
    }

    @Override
    public void uninstall() throws BundleException {
        this.assertNotUninstalled();
        try {
            OSGiRuntimeImpl runtimeImpl = (OSGiRuntimeImpl)this.getRuntime();
            runtimeImpl.undeploy(new URL(this.location));
            runtimeImpl.unregisterBundle(this);
            this.uninstalled = true;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            this.log.error("Cannot uninstall: " + this.getLocation(), (Throwable)ex);
        }
    }

    private URL toURL(String urlstr, URLStreamHandler sh) {
        if (urlstr == null) {
            return null;
        }
        try {
            return sh == null ? new URL(urlstr) : new URL(null, urlstr, sh);
        }
        catch (MalformedURLException ex) {
            if (sh == null && urlstr.startsWith("bundle")) {
                sh = new URLStreamHandler(){

                    protected URLConnection openConnection(URL url) throws IOException {
                        return null;
                    }
                };
                return this.toURL(urlstr, sh);
            }
            throw new IllegalArgumentException("Invalid URL: " + urlstr);
        }
    }
}

