/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.osgi.spi.management.MBeanProxy;
import org.jboss.osgi.spi.management.MBeanProxyException;
import org.jboss.osgi.spi.management.ManagedBundle;
import org.jboss.osgi.spi.management.ManagedFrameworkMBean;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiPackageAdmin;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.osgi.framework.Version;

public class RemotePackageAdmin
implements OSGiPackageAdmin {
    private OSGiRuntimeImpl runtime;

    public RemotePackageAdmin(OSGiRuntimeImpl runtime) {
        this.runtime = runtime;
    }

    public boolean resolveBundles(OSGiBundle[] bundles) {
        ObjectName[] bundleArr = this.getBundleNames(bundles);
        try {
            ManagedFrameworkMBean mbeanProxy = (ManagedFrameworkMBean)MBeanProxy.get(ManagedFrameworkMBean.class, (ObjectName)ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK, (MBeanServerConnection)this.runtime.getMBeanServer());
            return mbeanProxy.resolveBundles(bundleArr);
        }
        catch (MBeanProxyException ex) {
            throw new IllegalStateException("Cannot refresh packages", ex);
        }
    }

    public void refreshPackages(OSGiBundle[] bundles) {
        ObjectName[] bundleArr = this.getBundleNames(bundles);
        try {
            ManagedFrameworkMBean mbeanProxy = (ManagedFrameworkMBean)MBeanProxy.get(ManagedFrameworkMBean.class, (ObjectName)ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK, (MBeanServerConnection)this.runtime.getMBeanServer());
            mbeanProxy.refreshPackages(bundleArr);
        }
        catch (MBeanProxyException ex) {
            throw new IllegalStateException("Cannot refresh packages", ex);
        }
    }

    private ObjectName[] getBundleNames(OSGiBundle[] bundles) {
        ObjectName[] bundleArr = null;
        if (bundles != null) {
            bundleArr = new ObjectName[bundles.length];
            for (int i = 0; i < bundles.length; ++i) {
                OSGiBundle bundle = bundles[i];
                long id = bundle.getBundleId();
                String symbolicName = bundle.getSymbolicName();
                Version version = bundle.getVersion();
                bundleArr[i] = ManagedBundle.getObjectName((long)id, (String)symbolicName, (Version)version);
            }
        }
        return bundleArr;
    }
}

