/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.spi.management.MBeanProxy;
import org.jboss.osgi.spi.management.MBeanProxyException;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.management.ManagedFrameworkMBean;
import org.jboss.osgi.spi.management.ManagedServiceReference;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiPackageAdmin;
import org.jboss.osgi.testing.OSGiServiceReference;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.testing.internal.DeployerServiceClient;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.jboss.osgi.testing.internal.RemoteBundle;
import org.jboss.osgi.testing.internal.RemoteFramework;
import org.jboss.osgi.testing.internal.RemoteFrameworkException;
import org.jboss.osgi.testing.internal.RemotePackageAdmin;
import org.jboss.osgi.testing.internal.RemoteServiceReference;
import org.osgi.framework.BundleException;

public class RemoteRuntime
extends OSGiRuntimeImpl {
    private MBeanServerConnection mbeanServer;
    private ManagedFrameworkMBean managedFramework;

    public RemoteRuntime(OSGiTestHelper helper) {
        super(helper);
    }

    public OSGiBundle installBundle(String location) throws BundleException {
        try {
            BundleInfo info = BundleInfo.createBundleInfo((String)location);
            Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
            dep.setAutoStart(false);
            DeployerServiceClient deployer = new DeployerServiceClient(this, DeployerService.MBEAN_DEPLOYER_SERVICE);
            deployer.deploy(new Deployment[]{dep});
            String symbolicName = info.getSymbolicName();
            String version = info.getVersion().toString();
            int timeout = 50;
            ManagedBundleMBean bundleMBean = this.getRemoteFramework().getBundle(symbolicName, version);
            while (bundleMBean == null && 0 < timeout--) {
                Thread.sleep(200L);
                bundleMBean = this.getRemoteFramework().getBundle(symbolicName, version);
            }
            if (bundleMBean == null) {
                throw new IllegalStateException("Cannot find installed bundle: " + symbolicName + "-" + version);
            }
            RemoteBundle bundle = new RemoteBundle(this, bundleMBean, info);
            return this.registerBundle(bundle.getLocation(), bundle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (BundleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BundleException("Cannot install: " + location, (Throwable)ex);
        }
    }

    public void deploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        ObjectName oname = this.getDeployerServiceName(archiveURL);
        DeployerServiceClient deployer = new DeployerServiceClient(this, oname);
        deployer.deploy(archiveURL);
    }

    public void undeploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        ObjectName oname = this.getDeployerServiceName(archiveURL);
        DeployerServiceClient deployer = new DeployerServiceClient(this, oname);
        deployer.undeploy(archiveURL);
    }

    public OSGiBundle[] getBundles() {
        try {
            Set<ManagedBundleMBean> remoteBundles = this.getRemoteFramework().getBundles();
            HashSet<RemoteBundle> bundles = new HashSet<RemoteBundle>();
            for (ManagedBundleMBean remoteBundle : remoteBundles) {
                bundles.add(new RemoteBundle(this, remoteBundle));
            }
            OSGiBundle[] bundleArr = new OSGiBundle[bundles.size()];
            bundles.toArray(bundleArr);
            return bundleArr;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain remote bundles", ex);
        }
    }

    public OSGiBundle getBundle(long bundleId) {
        ManagedBundleMBean bundle = this.getRemoteFramework().getBundle(bundleId);
        return bundle != null ? new RemoteBundle(this, bundle) : null;
    }

    public OSGiServiceReference getServiceReference(String clazz) {
        ManagedServiceReference manref = this.getRemoteFramework().getServiceReference(clazz);
        return manref != null ? new RemoteServiceReference(manref) : null;
    }

    public OSGiServiceReference[] getServiceReferences(String clazz, String filter) {
        OSGiServiceReference[] srefs = null;
        ManagedServiceReference[] manrefs = this.getRemoteFramework().getServiceReferences(clazz, filter);
        if (manrefs != null) {
            srefs = new OSGiServiceReference[manrefs.length];
            for (int i = 0; i < manrefs.length; ++i) {
                srefs[i] = new RemoteServiceReference(manrefs[i]);
            }
        }
        return srefs;
    }

    public MBeanServerConnection getMBeanServer() {
        if (this.mbeanServer == null) {
            try {
                InitialContext iniCtx = this.getInitialContext();
                this.mbeanServer = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new IllegalStateException("Cannot obtain MBeanServerConnection", ex);
            }
        }
        return this.mbeanServer;
    }

    public OSGiPackageAdmin getPackageAdmin() {
        return new RemotePackageAdmin(this);
    }

    private RemoteFramework getRemoteFramework() {
        try {
            if (this.managedFramework == null) {
                this.managedFramework = (ManagedFrameworkMBean)MBeanProxy.get(ManagedFrameworkMBean.class, (ObjectName)ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK, (MBeanServerConnection)this.getMBeanServer());
            }
        }
        catch (MBeanProxyException ex) {
            throw new RemoteFrameworkException(ex);
        }
        return new RemoteFramework(){

            @Override
            public ManagedBundleMBean getBundle(String name, String version) {
                ManagedBundleMBean bundleMBean = null;
                ObjectName oname = RemoteRuntime.this.managedFramework.getBundle(name, version);
                if (oname != null) {
                    try {
                        bundleMBean = (ManagedBundleMBean)MBeanProxy.get(ManagedBundleMBean.class, (ObjectName)oname, (MBeanServerConnection)RemoteRuntime.this.getMBeanServer());
                    }
                    catch (MBeanProxyException ex) {
                        throw new RemoteFrameworkException(ex);
                    }
                }
                return bundleMBean;
            }

            @Override
            public ManagedBundleMBean getBundle(long bundleId) {
                ManagedBundleMBean bundleMBean = null;
                ObjectName oname = RemoteRuntime.this.managedFramework.getBundle(bundleId);
                if (oname != null) {
                    try {
                        bundleMBean = (ManagedBundleMBean)MBeanProxy.get(ManagedBundleMBean.class, (ObjectName)oname, (MBeanServerConnection)RemoteRuntime.this.getMBeanServer());
                    }
                    catch (MBeanProxyException ex) {
                        throw new RemoteFrameworkException(ex);
                    }
                }
                return bundleMBean;
            }

            @Override
            public Set<ManagedBundleMBean> getBundles() {
                HashSet<ManagedBundleMBean> remBundles = new HashSet<ManagedBundleMBean>();
                for (ObjectName bundleOName : RemoteRuntime.this.managedFramework.getBundles()) {
                    try {
                        ManagedBundleMBean remBundle = (ManagedBundleMBean)MBeanProxy.get(ManagedBundleMBean.class, (ObjectName)bundleOName, (MBeanServerConnection)RemoteRuntime.this.getMBeanServer());
                        remBundles.add(remBundle);
                    }
                    catch (MBeanProxyException ex) {
                        throw new RemoteFrameworkException(ex);
                    }
                }
                return remBundles;
            }

            @Override
            public ManagedServiceReference getServiceReference(String clazz) {
                return RemoteRuntime.this.managedFramework.getServiceReference(clazz);
            }

            @Override
            public ManagedServiceReference[] getServiceReferences(String clazz, String filter) {
                return RemoteRuntime.this.managedFramework.getServiceReferences(clazz, filter);
            }
        };
    }

    public boolean isRemoteRuntime() {
        return true;
    }

    private ObjectName getDeployerServiceName(URL archiveURL) throws MalformedObjectNameException {
        ObjectName oname;
        try {
            BundleInfo.createBundleInfo((URL)archiveURL);
            oname = DeployerService.MBEAN_DEPLOYER_SERVICE;
        }
        catch (Exception e) {
            oname = new ObjectName("jboss.system:service=MainDeployer");
        }
        return oname;
    }
}

