/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.internal;

// $Id: SocketInvocation.java 89609 2009-06-01 16:12:34Z thomas.diesler@jboss.com $

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;

import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.runtime.osgi.SocketConnector;

/**
 * A Socket invocation.
 * 
 * This is mainly used for remote framework testing.
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 16-May-2009
 */
public class SocketInvocation
{
   public static boolean isRemoteConnection()
   {
      return getHost() != null && getPort() != null;
   }

   private static String getPort()
   {
      String port = System.getProperty(SocketConnector.PROP_SOCKET_CONNECTOR_PORT);
      return port;
   }

   private static String getHost()
   {
      String host = System.getProperty(SocketConnector.PROP_SOCKET_CONNECTOR_HOST);
      return host;
   }

   public Response invoke(Request req) throws Exception
   {
      Socket socket = new Socket(InetAddress.getByName(getHost()), new Integer(getPort()));

      // Marshall the Request
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(baos);
      oos.writeObject(req);
      oos.close();

      InputStream reqBytes = new ByteArrayInputStream(baos.toByteArray());
      Util.copyStream(reqBytes, socket.getOutputStream());

      // Unmarshall the Response
      ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
      Response response = (Response)ois.readObject();
      return response;
   }
}
