/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.runtime.osgi;

// $Id: HuskyExtender.java 95822 2009-10-30 11:09:19Z thomas.diesler@jboss.com $

import java.util.List;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

/**
 * The Husky extender is a {@link BundleListener} that processes 
 * the {@link ManifestProcessor#HEADER_TEST_PACKAGE}.
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 17-May-2009
 */
public class HuskyExtender implements SynchronousBundleListener
{
   private ManifestProcessor processor;

   public HuskyExtender(ManifestProcessor processor)
   {
      this.processor = processor;
   }

   public void bundleChanged(BundleEvent event)
   {
      if (event.getType() == BundleEvent.STARTING)
      {
         Bundle bundle = event.getBundle();
         List<String> packages = processor.getTestPackages(bundle);
         if (packages != null)
            processor.registerPackageListener(bundle, packages);
      }
   }
}