/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.runtime.osgi;

// $Id: ManifestProcessor.java 100864 2010-02-11 11:46:29Z thomas.diesler@jboss.com $

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

import org.jboss.logging.Logger;
import org.jboss.osgi.husky.PackageListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/**
 * Processed the {@link #HEADER_TEST_PACKAGE} and registers the listeners.
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 30-Oct-2009
 */
public class ManifestProcessor
{
   // Provide Logging
   private static final Logger log = Logger.getLogger(ManifestProcessor.class);

   /** The manifest header that identifies a bundle as Husky test bundle: 'Test-Package' */
   public static final String HEADER_TEST_PACKAGE = "Test-Package";

   private BundleContext context;

   public ManifestProcessor(BundleContext context)
   {
      this.context = context;
   }

   public void registerPackageListener(Bundle bundle, List<String> packages)
   {
      // Check if we already have PackageListener serices for this bundle
      ServiceReference[] srefs = null;
      try
      {
         String filter = "(bundle=" + bundle.getSymbolicName() + ")";
         srefs = context.getServiceReferences(PackageListener.class.getName(), filter);
      }
      catch (InvalidSyntaxException ex)
      {
         // cannot get here
      }

      if (srefs == null)
      {
         log.info("Register test packages " + packages);
         Hashtable<String, String> properties = new Hashtable<String, String>();
         properties.put("bundle", bundle.getSymbolicName());
         PackageListener listener = new OSGiJUnitPackageListener(bundle, packages);
         bundle.getBundleContext().registerService(PackageListener.class.getName(), listener, properties);
      }
   }

   public List<String> getTestPackages(Bundle bundle)
   {
      String testPackage = (String)bundle.getHeaders().get(HEADER_TEST_PACKAGE);
      if (testPackage != null)
         return Arrays.asList(testPackage.split("[,\\s]"));

      return null;
   }
}