/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.runtime.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.osgi.husky.internal.AbstractConnector;
import org.jboss.osgi.husky.internal.Util;
import org.jboss.osgi.husky.runtime.Connector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SocketConnector
extends AbstractConnector {
    private static final Logger log = Logger.getLogger(SocketConnector.class);
    public static final String PROP_SOCKET_CONNECTOR_HOST = Connector.class.getName().toLowerCase() + ".host";
    public static final String PROP_SOCKET_CONNECTOR_PORT = Connector.class.getName().toLowerCase() + ".port";
    private ServiceRegistration sreg;
    private ListenerThread listenerThread;

    public SocketConnector(BundleContext context) {
        super(context);
    }

    public static boolean isRemoteConnection(BundleContext context) {
        return SocketConnector.getHost(context) != null && SocketConnector.getPort(context) != null;
    }

    private static String getPort(BundleContext context) {
        String port = context.getProperty(PROP_SOCKET_CONNECTOR_PORT);
        return port;
    }

    private static String getHost(BundleContext context) {
        String host = context.getProperty(PROP_SOCKET_CONNECTOR_HOST);
        return host;
    }

    public void start() throws Exception {
        super.start();
        BundleContext context = this.getBundleContext();
        String host = SocketConnector.getHost(context);
        String port = SocketConnector.getPort(context);
        Properties props = new Properties();
        props.setProperty("transport", "socket");
        props.setProperty("host", host);
        props.setProperty("port", port);
        this.listenerThread = new ListenerThread(host, new Integer(port));
        this.listenerThread.start();
        this.sreg = context.registerService(Connector.class.getName(), (Object)this, (Dictionary)props);
        log.info((Object)("SocketConnector registered: " + props));
    }

    public void stop() throws Exception {
        super.stop();
        if (this.sreg != null) {
            this.sreg.unregister();
        }
        if (this.listenerThread != null) {
            this.listenerThread.stopListener();
        }
    }

    class ListenerThread
    extends Thread {
        private ServerSocket serverSocket;

        public ListenerThread(String host, int port) {
            super("ConnectorThread");
            try {
                this.serverSocket = new ServerSocket();
                this.serverSocket.bind(new InetSocketAddress(host, port));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot create server socket", ex);
            }
        }

        public void stopListener() {
            try {
                log.debug((Object)"Stop SocketConnector");
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.serverSocket.isClosed()) {
                Socket socket = null;
                try {
                    log.debug((Object)"Waiting for connection ...");
                    socket = this.serverSocket.accept();
                    log.debug((Object)"Connection accepted");
                }
                catch (IOException ex) {
                    if (this.serverSocket.isClosed()) break;
                }
                if (socket == null) continue;
                try {
                    InputStream resStream = SocketConnector.this.process(socket.getInputStream());
                    Util.copyStream(resStream, socket.getOutputStream());
                }
                catch (Exception ex) {
                    log.error((Object)"Cannot process request", (Throwable)ex);
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException ex) {
                        log.error((Object)"Cannot close socket", (Throwable)ex);
                    }
                }
            }
        }
    }
}

