/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky;

import java.util.List;

import org.jboss.osgi.husky.runtime.Connector;

// $Id$

/**
 * A PackageListener that is associated with a {@link Connector}.
 * 
 * The PackageListener matches test {@link Request}s with the package names 
 * that it can handle. On a successful match the {@link Connector} will invoke
 * the {@link #runTests(Request)} method.
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 16-May-2009
 */
public interface PackageListener
{
   /**
    * Return the list of packages that this listener can handle.
    */
   List<String> getPackageNames();
   
   /**
    * Return true if the given {@link Request} is from a package 
    * that this listener can handle.
    */
   boolean match(Request request);

   /**
    * Called by {@link Connector} when this listener indicated that it can 
    * handle the test request.
    */
   Response runTests(Request request) throws Throwable;

}