/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.runtime.osgi;

// $Id$

import java.util.List;

import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.osgi.framework.Bundle;

/**
 * The Husky interceptor processes the {@link ManifestProcessor#HEADER_TEST_PACKAGE}.
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 30-Oct-2009
 */
public class HuskyInterceptor extends AbstractLifecycleInterceptor
{
   private ManifestProcessor processor;

   public HuskyInterceptor(ManifestProcessor processor)
   {
      this.processor = processor;
   }

   public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException
   {
      if (Bundle.STARTING == state)
      {
         Bundle bundle = context.getBundle();
         List<String> packages = processor.getTestPackages(bundle);
         if (packages != null)
            processor.registerPackageListener(bundle, packages);
      }
   }
}