/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.net.sockets.DefaultSocketFactory;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class JMXConnectorService {
    private LogService log;
    private JMXServiceURL serviceURL;
    private JMXConnectorServer jmxConnectorServer;
    private boolean shutdownRegistry;
    private Registry rmiRegistry;

    public JMXConnectorService(BundleContext context, MBeanServer mbeanServer, String host, int rmiPort) {
        this.log = new LogServiceTracker(context);
        String jmxConnectorServerPath = "/jmxconnector";
        try {
            this.rmiRegistry = LocateRegistry.getRegistry(host, rmiPort);
            try {
                this.rmiRegistry.list();
                this.log.log(4, "RMI registry running at host=" + host + ",port=" + rmiPort);
            }
            catch (RemoteException e) {
                this.log.log(4, "No RMI registry running at host=" + host + ",port=" + rmiPort + ".  Will create one.");
                this.rmiRegistry = LocateRegistry.createRegistry(rmiPort, null, (RMIServerSocketFactory)new DefaultSocketFactory(InetAddress.getByName(host)));
                this.shutdownRegistry = true;
            }
            this.serviceURL = new JMXServiceURL("service:jmx:rmi://" + host + "/jndi/rmi://" + host + ":" + rmiPort + jmxConnectorServerPath);
            this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.serviceURL, null, mbeanServer);
            this.log.log(4, "JMXConnectorServer created: " + this.serviceURL);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot create JMXConnectorServer", ex);
        }
    }

    public JMXServiceURL getServiceURL() {
        return this.serviceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.jmxConnectorServer.start();
            this.log.log(4, "JMXConnectorServer started: " + this.serviceURL);
        }
        catch (IOException ex) {
            this.log.log(1, "Cannot start JMXConnectorServer", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.jmxConnectorServer.stop();
            if (this.shutdownRegistry) {
                this.log.log(4, "Shutdown RMI registry");
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            this.log.log(4, "JMXConnectorServer stopped");
        }
        catch (IOException ex) {
            this.log.log(2, "Cannot stop JMXConnectorServer", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }
}

