/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.jmx.internal.JMXConnectorService;
import org.jboss.osgi.jmx.internal.MBeanServerLocator;
import org.jboss.osgi.jmx.internal.ManagedBundleServiceImpl;
import org.jboss.osgi.jmx.internal.RMIAdaptorFactory;
import org.jboss.osgi.spi.management.ManagedBundleService;
import org.jboss.osgi.spi.management.ManagedFramework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class JMXServiceActivator
implements BundleActivator {
    private JMXConnectorService jmxConnector;
    private String jmxHost;
    private String jmxRmiPort;
    private String rmiAdaptorPath;
    private MBeanServer mbeanServer;
    private ManagedFramework managedFramework;
    private ManagedBundleService managedBundleService;
    private LogService log;

    public void start(BundleContext context) {
        this.log = new LogServiceTracker(context);
        MBeanServerLocator locator = new MBeanServerLocator(context);
        this.mbeanServer = locator.getMBeanServer();
        context.registerService(MBeanServer.class.getName(), (Object)this.mbeanServer, null);
        this.log.log(4, "MBeanServer registered");
        this.managedBundleService = new ManagedBundleServiceImpl(context, this.mbeanServer);
        context.registerService(ManagedBundleService.class.getName(), (Object)this.managedBundleService, null);
        this.log.log(4, "ManagedBundleService registered");
        this.managedFramework = new ManagedFramework(context, this.mbeanServer);
        this.managedFramework.start();
        for (Bundle bundle : context.getBundles()) {
            this.managedBundleService.register(bundle);
        }
        this.jmxHost = context.getProperty("org.jboss.osgi.jmx.host");
        if (this.jmxHost == null) {
            this.jmxHost = "localhost";
        }
        this.jmxRmiPort = context.getProperty("org.jboss.osgi.jmx.rmi.port");
        if (this.jmxRmiPort == null) {
            this.jmxRmiPort = "1098";
        }
        this.rmiAdaptorPath = context.getProperty("org.jboss.osgi.jmx.rmi.adaptor");
        if (this.rmiAdaptorPath == null) {
            this.rmiAdaptorPath = "jmx/invoker/RMIAdaptor";
        }
        InitialContextTracker tracker = new InitialContextTracker(context, this.rmiAdaptorPath);
        tracker.open();
    }

    public void stop(BundleContext context) {
        for (Bundle bundle : context.getBundles()) {
            this.managedBundleService.unregister(bundle);
        }
        this.managedFramework.stop();
        this.stopJMXConnectorService();
    }

    private void stopJMXConnectorService() {
        if (this.jmxConnector != null) {
            this.jmxConnector.stop();
            this.jmxConnector = null;
        }
    }

    class InitialContextTracker
    extends ServiceTracker {
        private String rmiAdaptorPath;

        public InitialContextTracker(BundleContext context, String rmiAdaptorPath) {
            super(context, InitialContext.class.getName(), null);
            this.rmiAdaptorPath = rmiAdaptorPath;
        }

        public Object addingService(ServiceReference reference) {
            InitialContext iniCtx = (InitialContext)super.addingService(reference);
            if (JMXServiceActivator.this.jmxConnector == null) {
                JMXServiceActivator.this.jmxConnector = new JMXConnectorService(this.context, JMXServiceActivator.this.mbeanServer, JMXServiceActivator.this.jmxHost, Integer.parseInt(JMXServiceActivator.this.jmxRmiPort));
                JMXServiceActivator.this.jmxConnector.start();
            }
            try {
                iniCtx.createSubcontext("jmx").createSubcontext("invoker");
                StringRefAddr addr = new StringRefAddr(JMXServiceURL.class.getName(), JMXServiceActivator.this.jmxConnector.getServiceURL().toString());
                Reference ref = new Reference(MBeanServerConnection.class.getName(), addr, RMIAdaptorFactory.class.getName(), null);
                iniCtx.bind(this.rmiAdaptorPath, (Object)ref);
                JMXServiceActivator.this.log.log(3, "MBeanServerConnection bound to: " + this.rmiAdaptorPath);
            }
            catch (NamingException ex) {
                JMXServiceActivator.this.log.log(1, "Cannot bind RMIAdaptor", (Throwable)ex);
            }
            return iniCtx;
        }

        public void removedService(ServiceReference reference, Object service) {
            InitialContext iniCtx = (InitialContext)service;
            JMXServiceActivator.this.stopJMXConnectorService();
            try {
                iniCtx.unbind(this.rmiAdaptorPath);
                JMXServiceActivator.this.log.log(3, "MBeanServerConnection unbound from: " + this.rmiAdaptorPath);
            }
            catch (NamingException ex) {
                JMXServiceActivator.this.log.log(1, "Cannot unbind RMIAdaptor", (Throwable)ex);
            }
            super.removedService(reference, service);
        }
    }
}

