/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class MBeanServerLocator {
    private LogService log;
    private MBeanServer mbeanServer;

    public MBeanServerLocator(BundleContext context) {
        this.log = new LogServiceTracker(context);
        ServiceReference sref = context.getServiceReference(MBeanServer.class.getName());
        if (sref == null) {
            ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
            if (serverArr.size() > 1) {
                throw new IllegalStateException("Multiple MBeanServer instances not supported");
            }
            if (serverArr.size() == 1) {
                this.mbeanServer = serverArr.get(0);
                this.log.log(4, "Found MBeanServer: " + this.mbeanServer.getDefaultDomain());
            }
            if (this.mbeanServer == null) {
                this.log.log(4, "No MBeanServer, create one ...");
                this.mbeanServer = MBeanServerFactory.createMBeanServer();
            }
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }
}

