/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class MBeanServerService {
    private BundleContext context;
    private LogService log;

    public MBeanServerService(BundleContext context) {
        this.log = new LogServiceTracker(context);
        this.context = context;
    }

    public MBeanServer registerMBeanServer() {
        MBeanServer mbeanServer = null;
        ServiceReference sref = this.context.getServiceReference(MBeanServer.class.getName());
        if (sref != null) {
            mbeanServer = (MBeanServer)this.context.getService(sref);
            this.log.log(4, "Found MBeanServer fom service: " + mbeanServer.getDefaultDomain());
            return mbeanServer;
        }
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            this.log.log(2, "Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            this.log.log(4, "Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            this.log.log(4, "No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        this.context.registerService(MBeanServer.class.getName(), (Object)mbeanServer, null);
        this.log.log(4, "MBeanServer registered");
        return mbeanServer;
    }
}

