/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.spi.management.ManagedBundle;
import org.jboss.osgi.spi.management.ManagedBundleService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class ManagedBundleServiceImpl
implements ManagedBundleService {
    private LogService log;
    private MBeanServer mbeanServer;

    public ManagedBundleServiceImpl(BundleContext context, MBeanServer mbeanServer) {
        this.log = new LogServiceTracker(context);
        this.mbeanServer = mbeanServer;
    }

    public ManagedBundle register(Bundle bundle) {
        try {
            ManagedBundle mb = new ManagedBundle(bundle);
            ObjectName oname = mb.getObjectName();
            if (!this.mbeanServer.isRegistered(oname)) {
                this.log.log(4, "Register managed bundle: " + oname);
                this.mbeanServer.registerMBean(mb, oname);
            }
            return mb;
        }
        catch (JMException ex) {
            this.log.log(1, "Cannot register managed bundle", (Throwable)ex);
            return null;
        }
    }

    public void unregister(Bundle bundle) {
        try {
            ManagedBundle mb = new ManagedBundle(bundle);
            ObjectName oname = mb.getObjectName();
            this.log.log(4, "Unregister managed bundle: " + oname);
            if (this.mbeanServer.isRegistered(oname)) {
                this.mbeanServer.unregisterMBean(oname);
            }
        }
        catch (JMException ex) {
            this.log.log(1, "Cannot register managed bundle", (Throwable)ex);
        }
    }
}

