/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanServerService {
    private Logger log = LoggerFactory.getLogger(MBeanServerService.class);
    private BundleContext context;

    public MBeanServerService(BundleContext context) {
        this.context = context;
    }

    public MBeanServer registerMBeanServer() {
        MBeanServer mbeanServer = null;
        ServiceReference sref = this.context.getServiceReference(MBeanServer.class.getName());
        if (sref != null) {
            mbeanServer = (MBeanServer)this.context.getService(sref);
            this.log.debug("Found MBeanServer fom service: " + mbeanServer.getDefaultDomain());
            return mbeanServer;
        }
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            this.log.warn("Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            this.log.debug("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            this.log.debug("No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        this.context.registerService(MBeanServer.class.getName(), (Object)mbeanServer, null);
        this.log.debug("MBeanServer registered");
        return mbeanServer;
    }
}

