/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.osgi.spi.management.ManagedBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedBundleTracker
extends BundleTracker {
    private Logger log = LoggerFactory.getLogger(ManagedBundleTracker.class);
    private MBeanServer mbeanServer;

    public ManagedBundleTracker(BundleContext context, MBeanServer mbeanServer) {
        super(context, 39, null);
        this.mbeanServer = mbeanServer;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        Object retObject = super.addingBundle(bundle, event);
        this.register(bundle);
        return retObject;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (event != null && event.getType() == 16) {
            this.unregister(bundle);
        }
    }

    private ManagedBundle register(Bundle bundle) {
        try {
            ManagedBundle mb = new ManagedBundle(bundle);
            ObjectName oname = mb.getObjectName();
            if (!this.mbeanServer.isRegistered(oname)) {
                this.log.debug("Register managed bundle: " + oname);
                this.mbeanServer.registerMBean(mb, oname);
            }
            return mb;
        }
        catch (JMException ex) {
            this.log.error("Cannot register managed bundle", (Throwable)ex);
            return null;
        }
    }

    private void unregister(Bundle bundle) {
        try {
            ManagedBundle mb = new ManagedBundle(bundle);
            ObjectName oname = mb.getObjectName();
            if (this.mbeanServer.isRegistered(oname)) {
                this.log.debug("Unregister managed bundle: " + oname);
                this.mbeanServer.unregisterMBean(oname);
            }
        }
        catch (JMException ex) {
            this.log.error("Cannot register managed bundle", (Throwable)ex);
        }
    }
}

