/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.StandardMBean;
import org.jboss.osgi.jmx.internal.ManagedBundleTracker;
import org.jboss.osgi.spi.management.ManagedFrameworkMBean;
import org.jboss.osgi.spi.management.ManagedServiceReference;
import org.jboss.osgi.spi.management.ObjectNameFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedFrameworkImpl
implements ManagedFrameworkMBean {
    final Logger log = LoggerFactory.getLogger(ManagedFrameworkImpl.class);
    private MBeanServer mbeanServer;
    private BundleContext context;
    private ManagedBundleTracker bundleTracker;

    public ManagedFrameworkImpl(BundleContext context, MBeanServer mbeanServer) {
        if (context == null) {
            throw new IllegalArgumentException("Null BundleContext");
        }
        if (mbeanServer == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        if (context.getBundle().getBundleId() != 0L) {
            throw new IllegalArgumentException("Not the system bundle context: " + context);
        }
        this.context = context;
        this.mbeanServer = mbeanServer;
        this.bundleTracker = new ManagedBundleTracker(context, mbeanServer);
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public ObjectName getBundle(String symbolicName, String version) {
        ObjectName oname = null;
        String namestr = "jboss.osgi:name=" + symbolicName + "," + "version" + "=" + version + ",*";
        Set<ObjectName> names = this.mbeanServer.queryNames(ObjectNameFactory.create((String)namestr), null);
        if (names.size() > 0) {
            if (names.size() > 1) {
                this.log.warn("Multiple bundles found: " + names);
            }
            for (ObjectName aux : names) {
                if (oname == null) {
                    oname = aux;
                }
                Integer bestId = new Integer(oname.getKeyProperty("id"));
                Integer auxId = new Integer(aux.getKeyProperty("id"));
                if (bestId >= auxId) continue;
                oname = aux;
            }
        }
        return oname;
    }

    public ObjectName getBundle(long bundleId) {
        ObjectName oname = null;
        ObjectName pattern = ObjectNameFactory.create((String)("jboss.osgi:id=" + bundleId + ",*"));
        Set<ObjectName> names = this.mbeanServer.queryNames(pattern, null);
        if (names.size() > 0) {
            oname = names.iterator().next();
        }
        return oname;
    }

    public Set<ObjectName> getBundles() {
        ObjectName pattern = ObjectNameFactory.create((String)"jboss.osgi:*");
        Set<ObjectName> names = this.mbeanServer.queryNames(pattern, new IsBundleQueryExp());
        return names;
    }

    public ManagedServiceReference getServiceReference(String clazz) {
        ServiceReference sref = this.getBundleContext().getServiceReference(clazz);
        if (sref == null) {
            return null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : sref.getPropertyKeys()) {
            props.put(key, sref.getProperty(key));
        }
        return new ManagedServiceReference(props);
    }

    public ManagedServiceReference[] getServiceReferences(String clazz, String filter) {
        ServiceReference[] srefs;
        ArrayList<ManagedServiceReference> foundRefs = new ArrayList<ManagedServiceReference>();
        try {
            srefs = this.getBundleContext().getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter syntax: " + filter);
        }
        if (srefs != null) {
            for (ServiceReference sref : srefs) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (String key : sref.getPropertyKeys()) {
                    props.put(key, sref.getProperty(key));
                }
                foundRefs.add(new ManagedServiceReference(props));
            }
        }
        ManagedServiceReference[] manrefs = null;
        if (foundRefs.size() > 0) {
            manrefs = foundRefs.toArray(new ManagedServiceReference[foundRefs.size()]);
        }
        return manrefs;
    }

    public void refreshPackages(ObjectName[] objectNames) {
        ServiceReference sref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (sref != null) {
            PackageAdmin service = (PackageAdmin)this.getBundleContext().getService(sref);
            Bundle[] bundleArr = null;
            if (objectNames != null) {
                ArrayList<String> symbolicNames = new ArrayList<String>();
                for (ObjectName oname : objectNames) {
                    symbolicNames.add(oname.getKeyProperty("name"));
                }
                HashSet<Bundle> bundleSet = new HashSet<Bundle>();
                for (Bundle bundle : this.getBundleContext().getBundles()) {
                    if (!symbolicNames.contains(bundle.getSymbolicName())) continue;
                    bundleSet.add(bundle);
                }
                bundleArr = new Bundle[bundleSet.size()];
                bundleSet.toArray(bundleArr);
            }
            service.refreshPackages(bundleArr);
        }
    }

    public void start() {
        this.bundleTracker.open();
        try {
            if (this.mbeanServer != null) {
                StandardMBean mbean = new StandardMBean(this, ManagedFrameworkMBean.class);
                this.mbeanServer.registerMBean(mbean, ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK);
            }
        }
        catch (JMException ex) {
            this.log.warn("Cannot register: " + ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK);
        }
    }

    public void stop() {
        try {
            if (this.mbeanServer != null && this.mbeanServer.isRegistered(MBEAN_MANAGED_FRAMEWORK)) {
                this.mbeanServer.unregisterMBean(ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK);
            }
        }
        catch (JMException ex) {
            this.log.warn("Cannot register: " + ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK);
        }
    }

    static class IsBundleQueryExp
    implements QueryExp {
        private static final long serialVersionUID = 1L;

        IsBundleQueryExp() {
        }

        public boolean apply(ObjectName name) {
            return name.getKeyProperty("name") != null;
        }

        public void setMBeanServer(MBeanServer server) {
        }
    }
}

