/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.net.sockets.DefaultSocketFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConnectorService {
    private Logger log = LoggerFactory.getLogger(JMXConnectorService.class);
    private JMXServiceURL serviceURL;
    private JMXConnectorServer jmxConnectorServer;
    private boolean shutdownRegistry;
    private Registry rmiRegistry;

    public JMXConnectorService(BundleContext context, MBeanServer mbeanServer, String host, int rmiPort) throws IOException {
        this.rmiRegistry = LocateRegistry.getRegistry(host, rmiPort);
        try {
            this.rmiRegistry.list();
            this.log.debug("RMI registry running at host=" + host + ",port=" + rmiPort);
        }
        catch (RemoteException e) {
            this.log.debug("No RMI registry running at host=" + host + ",port=" + rmiPort + ".  Will create one.");
            this.rmiRegistry = LocateRegistry.createRegistry(rmiPort, null, (RMIServerSocketFactory)new DefaultSocketFactory(InetAddress.getByName(host)));
            this.shutdownRegistry = true;
        }
        this.serviceURL = JMXConnectorService.getServiceURL(host, rmiPort);
        this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.serviceURL, null, mbeanServer);
        this.log.debug("JMXConnectorServer created: " + this.serviceURL);
    }

    static JMXServiceURL getServiceURL(String host, int rmiPort) {
        String jmxConnectorURL = "service:jmx:rmi://" + host + "/jndi/rmi://" + host + ":" + rmiPort + "/jmxconnector";
        try {
            return new JMXServiceURL(jmxConnectorURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid connector URL: " + jmxConnectorURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.jmxConnectorServer.start();
            this.log.debug("JMXConnectorServer started: " + this.serviceURL);
        }
        catch (IOException ex) {
            this.log.error("Cannot start JMXConnectorServer", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.jmxConnectorServer.stop();
            if (this.shutdownRegistry) {
                this.log.debug("Shutdown RMI registry");
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            this.log.debug("JMXConnectorServer stopped");
        }
        catch (IOException ex) {
            this.log.warn("Cannot stop JMXConnectorServer", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }
}

