/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.service.useradmin;

import java.io.IOException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import org.osgi.jmx.Item;
import org.osgi.jmx.JmxConstants;

public interface UserAdminMBean {
    public static final String OBJECTNAME = "osgi.compendium:service=useradmin,version=1.1";
    public static final String NAME = "Name";
    public static final Item NAME_ITEM = new Item("Name", "The user name for this authorization object", SimpleType.STRING, new String[0]);
    public static final String ROLES = "Roles";
    public static final Item ROLES_ITEM = new Item("Roles", "The names of the roles encapsulated by this auth object", JmxConstants.STRING_ARRAY_TYPE, new String[0]);
    public static final CompositeType AUTORIZATION_TYPE = Item.compositeType("AUTHORIZATION", "An authorization object defines which roles has a user got", NAME_ITEM, ROLES_ITEM);
    public static final String TYPE = "Type";
    public static final Item TYPE_ITEM = new Item("Type", "An integer representing type of the role: {0=Role,1=user,2=group}", SimpleType.INTEGER, new String[0]);
    public static final String PROPERTIES = "Properties";
    public static final Item PROPERTIES_ITEM = new Item("Properties", "A properties as defined by org.osgi.service.useradmin.Role", JmxConstants.PROPERTIES_TYPE, new String[0]);
    public static final CompositeType ROLE_TYPE = Item.compositeType("ROLE", "Mapping of org.osgi.service.useradmin.Role for remote management purposes. User and Group extend Role", NAME_ITEM, TYPE_ITEM, PROPERTIES_ITEM);
    public static final String CREDENTIALS = "Credentials";
    public static final Item CREDENTIALS_ITEM = new Item("Credentials", "The credentials for this user", JmxConstants.PROPERTIES_TYPE, new String[0]);
    public static final CompositeType USER_TYPE = Item.extend(ROLE_TYPE, "USER", "Mapping of org.osgi.service.useradmin.User for remote management purposes. User extends Role", CREDENTIALS_ITEM);
    public static final String MEMBERS = "Members";
    public static final Item MEMBERS_ITEM = new Item("Members", "The members of this group", JmxConstants.STRING_ARRAY_TYPE, new String[0]);
    public static final String REQUIRED_MEMBERS = "RequiredMembers";
    public static final Item REQUIRED_MEMBERS_ITEM = new Item("RequiredMembers", "The required members of this group", JmxConstants.STRING_ARRAY_TYPE, new String[0]);
    public static final CompositeType GROUP_TYPE = Item.extend(USER_TYPE, "GROUP", "Mapping of org.osgi.service.useradmin.Group for remote management purposes. Group extends User which in turn extends Role", MEMBERS_ITEM, REQUIRED_MEMBERS_ITEM);

    public void addCredential(String var1, byte[] var2, String var3) throws IOException;

    public void addCredential(String var1, String var2, String var3) throws IOException;

    public boolean addMember(String var1, String var2) throws IOException;

    public void addProperty(String var1, String var2, String var3) throws IOException;

    public void addProperty(String var1, byte[] var2, String var3) throws IOException;

    public boolean addRequiredMember(String var1, String var2) throws IOException;

    public void createUser(String var1) throws IOException;

    public void createGroup(String var1) throws IOException;

    public void createRole(String var1) throws IOException;

    public CompositeData getAuthorization(String var1) throws IOException;

    public TabularData getCredentials(String var1) throws IOException;

    public CompositeData getGroup(String var1) throws IOException;

    public String[] listGroups() throws IOException;

    public String[] getGroups(String var1) throws IOException;

    public String[] getImpliedRoles(String var1) throws IOException;

    public String[] getMembers(String var1) throws IOException;

    public TabularData getProperties(String var1) throws IOException;

    public String[] getRequiredMembers(String var1) throws IOException;

    public CompositeData getRole(String var1) throws IOException;

    public String[] listRoles() throws IOException;

    public String[] getRoles(String var1) throws IOException;

    public CompositeData getUser(String var1) throws IOException;

    public String getUser(String var1, String var2) throws IOException;

    public String[] listUsers() throws IOException;

    public String[] getUsers(String var1) throws IOException;

    public void removeCredential(String var1, String var2) throws IOException;

    public boolean removeMember(String var1, String var2) throws IOException;

    public void removeProperty(String var1, String var2) throws IOException;

    public boolean removeRole(String var1) throws IOException;

    public boolean removeGroup(String var1) throws IOException;

    public boolean removeUser(String var1) throws IOException;
}

