/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.microcontainer.internal;

// $Id: EmbeddedBeansDeployer.java 89653 2009-06-02 07:16:24Z thomas.diesler@jboss.com $

import java.net.URL;

import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

/**
 * Boostrap the Microcontainer
 * 
 * @author thomas.diesler@jboss.com
 * @since 27-Jun-2008
 */
public class EmbeddedBeansDeployer extends BasicBootstrap
{
   private LogService log;
   private BasicXMLDeployer deployer;

   public EmbeddedBeansDeployer(BundleContext context)
   {
      this.log = new LogServiceTracker(context);
      
      // Get or bootstrap the kernel
      if (kernel == null)
      {
         try
         {
            super.bootstrap();
            log.log(LogService.LOG_DEBUG, "bootstrap kernel: " + kernel);
         }
         catch (Throwable e)
         {
            throw new IllegalStateException("Cannot bootstrap kernel", e);
         }
      }
      deployer = new BasicXMLDeployer(kernel);
   }

   /** 
    * Deploy MC beans from URL
    */
   public void deploy(URL url)
   {
      log.log(LogService.LOG_DEBUG, "deploy: " + url);
      ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
      try
      {
         Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
         deployer.deploy(url);
         deployer.validate();
      }
      catch (Throwable e)
      {
         throw new IllegalStateException("Cannot deploy beans from: " + url, e);
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(ctxLoader);
      }
   }

   /**
    * Undeploy MC beans from URL
    */
   public void undeploy(URL url)
   {
      log.log(LogService.LOG_DEBUG, "undeploy: " + url);
      try
      {
         deployer.undeploy(url);
      }
      catch (Throwable e)
      {
         throw new IllegalStateException("Cannot undeploy beans from: " + url, e);
      }
   }
}