/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.microcontainer.internal;

//$Id: MicrocontainerServiceActivator.java 89589 2009-06-01 08:00:17Z thomas.diesler@jboss.com $

import org.jboss.osgi.spi.service.MicrocontainerService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/**
 * A BundleActivator that registers the {@link MicrocontainerService}
 * 
 * @author thomas.diesler@jboss.com
 * @since 24-Apr-2009
 */
public class MicrocontainerServiceActivator implements BundleActivator
{
   private MicrocontainerServiceImpl mcService;

   public void start(BundleContext context)
   {
      ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
      try
      {
         Thread.currentThread().setContextClassLoader(getClass().getClassLoader());
         mcService = new MicrocontainerServiceImpl(context);
         mcService.start();
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(ctxLoader);
      }
   }

   public void stop(BundleContext context)
   {
      if (mcService != null)
         mcService.stop();
   }
}