/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.microcontainer.integration;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.StandardMBean;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.osgi.spi.management.MicrocontainerServiceMBean;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.service.DeploymentRegistryService;
import org.jboss.osgi.spi.service.MicrocontainerService;
import org.jboss.osgi.spi.util.BundleDeployment;
import org.jboss.osgi.spi.util.BundleDeploymentFactory;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMicrocontainerService
implements DeployerService,
MicrocontainerService {
    private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private ServiceTracker registryTracker;

    public abstract Kernel getKernel();

    public abstract void logDebug(String var1);

    public abstract void logWarning(String var1, Exception var2);

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public List<String> getRegisteredBeans() {
        ArrayList<String> names = new ArrayList<String>();
        AbstractController controller = (AbstractController)this.getKernel().getController();
        for (ControllerContext ctx : controller.getAllContexts()) {
            if (!(ctx instanceof KernelControllerContext) && !(ctx instanceof PreInstalledControllerContext)) continue;
            names.add(ctx.getName().toString());
        }
        return names;
    }

    public Object getRegisteredBean(String beanName) {
        ControllerContext context = this.getKernel().getController().getInstalledContext((Object)beanName);
        return context != null ? context.getTarget() : null;
    }

    public <T> T getRegisteredBean(Class<T> clazz, String beanName) {
        return (T)this.getRegisteredBean(beanName);
    }

    public void deploy(URL url) throws BundleException {
        BundleDeployment dep = BundleDeploymentFactory.createBundleDeployment((URL)url);
        this.deploy(new BundleDeployment[]{dep});
    }

    public boolean undeploy(URL url) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        BundleDeployment dep = registry.getBundleDeployment(url);
        if (dep == null) {
            this.logWarning("Package not deployed: " + url);
            return false;
        }
        try {
            MainDeployer mainDeployer = (MainDeployer)this.getRegisteredBean("MainDeployer");
            mainDeployer.removeDeployment((String)dep.getMetadata());
            mainDeployer.process();
            return true;
        }
        catch (Exception ex) {
            this.logWarning("Cannot undeploy bundle", ex);
            return false;
        }
    }

    public void deploy(BundleDeployment[] depArr) throws BundleException {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ArrayList<VFSDeployment> depList = new ArrayList<VFSDeployment>();
            MainDeployer mainDeployer = (MainDeployer)this.getRegisteredBean("MainDeployer");
            DeploymentRegistryService registry = this.getDeploymentRegistry();
            for (BundleDeployment dep : depArr) {
                VirtualFile file = VFS.createNewRoot((URL)dep.getLocation());
                VFSDeployment deployment = this.deploymentFactory.createVFSDeployment(file);
                dep.setMetadata((Object)deployment.getName());
                registry.registerBundleDeployment(dep);
                depList.add(deployment);
                MutableAttachments att = (MutableAttachments)deployment.getPredeterminedManagedObjects();
                att.addAttachment("org.jboss.osgi.start.level", (Object)new Integer(dep.getStartLevel()));
                att.addAttachment("org.jboss.osgi.auto.start", (Object)new Boolean(dep.isAutoStart()));
                mainDeployer.addDeployment((Deployment)deployment);
            }
            mainDeployer.process();
            Deployment[] deploymentArr = depList.toArray(new Deployment[depList.size()]);
            mainDeployer.checkComplete(deploymentArr);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new BundleException("Cannot deploy bundles", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    public void undeploy(BundleDeployment[] depArr) throws BundleException {
        try {
            MainDeployer mainDeployer = (MainDeployer)this.getRegisteredBean("MainDeployer");
            DeploymentRegistryService registry = this.getDeploymentRegistry();
            for (BundleDeployment dep : depArr) {
                registry.unregisterBundleDeployment(dep);
                mainDeployer.removeDeployment((String)dep.getMetadata());
            }
            mainDeployer.process();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            this.logWarning("Cannot undeploy bundles", ex);
        }
    }

    protected void installBean(KernelController controller, String beanName, Object beanImpl) {
        try {
            AbstractControllerContextActions actions = new AbstractControllerContextActions(new HashMap());
            controller.install((ControllerContext)new PreInstalledControllerContext(beanName, (ControllerContextActions)actions, beanImpl));
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Cannot register bean: " + beanName, ex);
        }
    }

    protected void registerMicrocontainerServiceMBean(MBeanServer mbeanServer) {
        try {
            StandardMBean mbean = new StandardMBean((MicrocontainerServiceMBean)this, MicrocontainerServiceMBean.class);
            mbeanServer.registerMBean(mbean, MicrocontainerServiceMBean.MBEAN_MICROCONTAINER_SERVICE);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot register MicrocontainerServiceMBean", ex);
        }
    }

    protected void unregisterMicrocontainerServiceMBean(MBeanServer mbeanServer) {
        if (mbeanServer.isRegistered(MicrocontainerServiceMBean.MBEAN_MICROCONTAINER_SERVICE)) {
            try {
                this.logDebug("Unregister MicrocontainerServiceMBean");
                mbeanServer.unregisterMBean(MicrocontainerServiceMBean.MBEAN_MICROCONTAINER_SERVICE);
            }
            catch (Exception ex) {
                this.logWarning("Cannot unregister MicrocontainerServiceMBean", ex);
            }
        }
    }

    private DeploymentRegistryService getDeploymentRegistry() {
        if (this.registryTracker == null) {
            BundleContext context = this.getRegisteredBean(BundleContext.class, "jboss.osgi:service=BundleContext");
            this.registryTracker = new ServiceTracker(context, DeploymentRegistryService.class.getName(), null);
            this.registryTracker.open();
        }
        return (DeploymentRegistryService)this.registryTracker.getService();
    }

    static class PreInstalledControllerContext
    extends AbstractControllerContext {
        public PreInstalledControllerContext(Object name, ControllerContextActions actions, Object target) {
            super(name, actions, null, target);
        }
    }
}

