/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.microcontainer.internal;

import java.net.URL;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.microcontainer.internal.EmbeddedXMLDeployer;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class EmbeddedKernelBootstrap
extends BasicBootstrap {
    private LogService log;
    private EmbeddedXMLDeployer deployer;

    public EmbeddedKernelBootstrap(BundleContext context) {
        this.log = new LogServiceTracker(context);
        if (this.kernel == null) {
            try {
                this.log.log(4, "bootstrap kernel: " + this.kernel);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Cannot bootstrap kernel", e);
            }
        }
        this.deployer = new EmbeddedXMLDeployer(this.kernel);
    }

    public void deploy(URL url) {
        this.log.log(4, "deploy: " + url);
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.deployer.deploy(url);
            this.deployer.validate();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot deploy beans from: " + url, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    public void undeploy(URL url) {
        this.log.log(4, "undeploy: " + url);
        try {
            this.deployer.undeploy(url);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot undeploy beans from: " + url, e);
        }
    }
}

