/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.microcontainer.internal;

import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.jbossxb.XMLBindingService;
import org.jboss.osgi.microcontainer.integration.AbstractMicrocontainerService;
import org.jboss.osgi.microcontainer.internal.EmbeddedKernelBootstrap;
import org.jboss.osgi.spi.management.MicrocontainerServiceMBean;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.service.MicrocontainerService;
import org.jboss.virtual.VFS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class MicrocontainerServiceImpl
extends AbstractMicrocontainerService
implements MicrocontainerServiceMBean {
    private BundleContext context;
    private EmbeddedKernelBootstrap deployer;
    private LogService log;

    public MicrocontainerServiceImpl(BundleContext context) {
        this.context = context;
        this.log = new LogServiceTracker(context);
        VFS.init();
        this.deployer = new EmbeddedKernelBootstrap(context);
    }

    public Kernel getKernel() {
        return this.deployer.getKernel();
    }

    public void logDebug(String message) {
        this.log.log(4, message);
    }

    public void logWarning(String message, Exception ex) {
        this.log.log(2, message, (Throwable)ex);
    }

    void start() {
        Filter filter;
        final MicrocontainerServiceImpl mcServiceImpl = this;
        Kernel kernel = this.getKernel();
        final KernelController controller = kernel.getController();
        this.installBean(controller, "jboss.osgi:service=BundleContext", this.context);
        this.installBean(controller, "jboss.kernel:service=Kernel", kernel);
        this.installBean(controller, "jboss.kernel:service=KernelController", controller);
        try {
            String jmxService = "(objectClass=" + MBeanServer.class.getName() + ")";
            String xmlService = "(objectClass=" + XMLBindingService.class.getName() + ")";
            filter = this.context.createFilter("(|" + jmxService + xmlService + ")");
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException("Invalid filter syntax");
        }
        ServiceTracker tracker = new ServiceTracker(this.context, filter, null){
            XMLBindingService xmlService;
            MBeanServer mbeanServer;

            public Object addingService(ServiceReference sref) {
                Object service = super.addingService(sref);
                List<String> classList = Arrays.asList((String[])sref.getProperty("objectClass"));
                if (classList.contains(MBeanServer.class.getName())) {
                    this.mbeanServer = (MBeanServer)service;
                }
                if (classList.contains(XMLBindingService.class.getName())) {
                    this.xmlService = (XMLBindingService)service;
                }
                if (this.mbeanServer != null && this.xmlService != null) {
                    MicrocontainerServiceImpl.this.installBean(controller, "jboss.osgi:service=MBeanServer", this.mbeanServer);
                    URL deployersURL = this.context.getBundle().getResource("META-INF/base-deployers-beans.xml");
                    MicrocontainerServiceImpl.this.deployer.deploy(deployersURL);
                    MicrocontainerServiceImpl.this.log.log(4, "Register MicrocontainerService");
                    this.context.registerService(MicrocontainerService.class.getName(), (Object)mcServiceImpl, null);
                    Properties props = new Properties();
                    props.setProperty("provider", "microcontainer");
                    MicrocontainerServiceImpl.this.log.log(4, "Register DeployerService");
                    this.context.registerService(DeployerService.class.getName(), (Object)mcServiceImpl, (Dictionary)props);
                    MicrocontainerServiceImpl.this.registerMicrocontainerServiceMBean(this.mbeanServer);
                }
                return service;
            }
        };
        tracker.open();
    }

    void stop() {
        ServiceReference sref = this.context.getServiceReference(MBeanServer.class.getName());
        if (sref != null) {
            MBeanServer mbeanServer = (MBeanServer)this.context.getService(sref);
            this.unregisterMicrocontainerServiceMBean(mbeanServer);
        }
    }
}

