/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

//$Id: GTargetComponent.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * A target component is one that can be a target for a
 * listener, registration-listener or service elements.
 * This is used in contexts where the requirement is a single
 * provided object that will implement a particular interface.
 * The provided object is obtained either from a <ref> element
 * or an inlined <bean> or <reference>.
 * 
 * <xsd:group name="GtargetComponent">
 *  <xsd:choice>
 *    <xsd:element name="bean" type="Tinlined-bean" />
 *    <xsd:element name="reference" type="Tinlined-reference" />
 *    <xsd:element name="ref" type="Tref" />
 *    <xsd:any namespace="##other" processContents="strict" />
 *  </xsd:choice>
 * </xsd:group>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */

// [JBXB-218] Requires property order even when maked as choice
// https://jira.jboss.org/jira/browse/JBXB-218
//@XmlType(name = "GtargetComponent", namespace = BlueprintContext.XMLNS_BLUEPRINT)
//@JBossXmlModelGroup(kind = JBossXmlConstants.MODEL_GROUP_CHOICE)

@XmlType(name = "GtargetComponent", namespace = BlueprintContext.XMLNS_BLUEPRINT, propOrder = { "bean", "reference", "refElement" })
public class GTargetComponent extends TComponent
{
   protected TBean bean;
   protected TReference reference;
   protected TRef refElement;
   protected List<Object> any;

   public TBean getBean()
   {
      return bean;
   }

   public void setBean(TBean value)
   {
      this.bean = value;
   }

   public TReference getReference()
   {
      return reference;
   }

   public void setReference(TReference value)
   {
      this.reference = value;
   }

   @XmlElement(name = "ref")
   public TRef getRefElement()
   {
      return refElement;
   }

   public void setRefElement(TRef value)
   {
      this.refElement = value;
   }

   public List<Object> getAny()
   {
      if (any == null)
         any = new ArrayList<Object>();

      return this.any;
   }
}
