/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TValue.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * Tvalue is the type used for <value> elements.  
 * 
 * The <value> element is used for types that can be created from a single string value.
 * 
 * The string value is the data value for the element.  
 * The optional type attribute allows a target conversion value to be explicitly specified.
 * 
 * <xsd:complexType name="Tvalue" mixed="true">
 *  <xsd:attribute name="type" type="Ttype" />
 * </xsd:complexType>
 * 
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Tvalue", namespace = BlueprintContext.XMLNS_BLUEPRINT)
public class TValue
{
   protected String content;
   protected String type;

   public String getContent()
   {
      return content;
   }

   public void setContent(String value)
   {
      this.content = value;
   }

   @XmlAttribute
   public String getType()
   {
      return type;
   }

   public void setType(String value)
   {
      this.type = value;
   }
}
