/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.reflect;

// $Id: ServiceMetadataImpl.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.Collection;
import java.util.List;

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.xb.TAutoExportModes;
import org.jboss.osgi.blueprint.parser.xb.TService;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.Target;

/**
 * Metadata representing a service to be exported by a module context.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class ServiceMetadataImpl extends ComponentMetadataImpl implements ServiceMetadata
{
   private TService tService;
   private Target target;

   public ServiceMetadataImpl(BlueprintContext context, BlueprintMetadata blueprint, TService tService)
   {
      super(context, blueprint, tService);
      this.tService = tService;
   }

   public int getAutoExport()
   {
      int modeValue = AUTO_EXPORT_DISABLED;
      TAutoExportModes mode = tService.getAutoExport();

      if (mode == TAutoExportModes.all_classes)
         modeValue = AUTO_EXPORT_ALL_CLASSES;
      else if (mode == TAutoExportModes.class_hierarchy)
         modeValue = AUTO_EXPORT_CLASS_HIERARCHY;
      else if (mode == TAutoExportModes.interfaces)
         modeValue = AUTO_EXPORT_INTERFACES;

      return modeValue;
   }

   public List<String> getInterfaces()
   {
      return tService.getInterfaces().getValues();
   }

   public int getRanking()
   {
      return tService.getRanking();
   }

   public Collection<RegistrationListener> getRegistrationListeners()
   {
      throw new NotImplementedException();
   }

   public Target getServiceComponent()
   {
      if (target == null)
      {
         if (tService.getBean() != null)
         {
            ComponentFactory factory = new ComponentFactory(context, blueprint);
            target = (Target)factory.createComponent(this, tService.getBean(), true);
         }
         else if (tService.getRef() != null)
         {
            target = new RefMetadataImpl(context, blueprint, tService.getRef());
         }
      }

      if (target == null)
         throw new IllegalStateException("Cannot get service component");

      return target;
   }

   public List<MapEntry> getServiceProperties()
   {
      throw new NotImplementedException();
   }

   public String toString()
   {
      return "Service[id=" + getId() + "]";
   }
}
