/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.blueprint;

//$Id: MockBlueprintContext.java 90472 2009-06-19 15:11:39Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.BlueprintParser;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

/**
 * A mock {@link BlueprintContext}
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class MockBlueprintContext implements BlueprintContext
{
   public BlueprintParser getBlueprintParser()
   {
      throw new NotImplementedException();
   }

   public BundleContext getBundleContext()
   {
      throw new NotImplementedException();
   }

   public LogService getLog()
   {
      return new LogService()
      {
         public void log(int level, String message)
         {
            System.out.println(logLevel(level) + " - " + message);
         }

         public void log(int level, String message, Throwable ex)
         {
            System.out.println(logLevel(level) + " - " + message);
            ex.printStackTrace(System.out);
         }

         public void log(ServiceReference arg0, int arg1, String arg2)
         {
            throw new NotImplementedException();
         }

         public void log(ServiceReference arg0, int arg1, String arg2, Throwable arg3)
         {
            throw new NotImplementedException();
         }
      };
   }

   private String logLevel(int level)
   {
      String logLevel;
      switch (level)
      {
         case LogService.LOG_DEBUG:
            logLevel = "DEBUG";
            break;
         case LogService.LOG_INFO:
            logLevel = "INFO";
            break;
         case LogService.LOG_WARNING:
            logLevel = "WARN";
            break;
         case LogService.LOG_ERROR:
            logLevel = "ERROR";
            break;
         default:
            logLevel = "Level=" + level;
      }
      return logLevel;
   }
}