/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.blueprint.parser;

//$Id: RootElementParserTestCase.java 91370 2009-07-17 10:46:20Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertEquals;

import java.math.BigInteger;
import java.net.URL;

import org.jboss.osgi.blueprint.parser.BlueprintParser;
import org.jboss.osgi.blueprint.parser.xb.TActivation;
import org.jboss.osgi.blueprint.parser.xb.TAvailability;
import org.jboss.osgi.blueprint.parser.xb.TBlueprint;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.jboss.test.osgi.blueprint.MockBlueprintContext;
import org.junit.Test;

/**
 * Blueprint parser tests
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class RootElementParserTestCase
{
   @Test
   public void testBlueprintDefaultAttributes() throws Exception
   {
      URL xmlURL = new OSGiTestHelper().getResourceURL("parser/blueprint-root-defaults.xml");
      TBlueprint blueprint = new BlueprintParser(new MockBlueprintContext()).parse(xmlURL);
      
      // assert default attributes
      assertEquals("availability", TAvailability.mandatory, blueprint.getDefaultAvailability());
      assertEquals("timeout", new BigInteger("300000"), blueprint.getDefaultTimeout());
      assertEquals("activation", TActivation.eager, blueprint.getDefaultActivation());
   }

   @Test
   public void testBlueprintDescription() throws Exception
   {
      URL xmlURL = new OSGiTestHelper().getResourceURL("parser/blueprint-basic-root.xml");
      TBlueprint blueprint = new BlueprintParser(new MockBlueprintContext()).parse(xmlURL);
      
      // assert default attributes
      assertEquals("availability", TAvailability.optional, blueprint.getDefaultAvailability());
      assertEquals("timeout", new BigInteger("100000"), blueprint.getDefaultTimeout());
      assertEquals("activation", TActivation.lazy, blueprint.getDefaultActivation());
      
      // assert description
      assertEquals("some text", blueprint.getDescription());
   }
}