/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.osgi.framework.filter;

import java.util.Dictionary;

import org.jboss.osgi.framework.filter.model.Operation;
import org.jboss.osgi.framework.filter.parser.FilterParser;
import org.jboss.osgi.framework.filter.property.PropertySource;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/**
 * FilterImpl.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class FilterImpl implements Filter
{
   /** The operation */
   private Operation operation;

   /** The cached string */
   private String cachedString;
   
   /**
    * Create a new FilterImpl.
    * 
    * @param filter the filter
    * @throws InvalidSyntaxException if the filter syntax is invalid
    */
   public FilterImpl(String filter) throws InvalidSyntaxException
   {
      if (filter == null)
         throw new InvalidSyntaxException("Null filter", "?");

      FilterParser parser = new FilterParser();
      this.operation = parser.parse(filter);
   }
   
   @SuppressWarnings("unchecked")
   public boolean match(Dictionary dictionary)
   {
      return operation.match(PropertySource.fromDictionary(dictionary, false));
   }

   public boolean match(ServiceReference reference)
   {
      return operation.match(PropertySource.fromServiceReference(reference));
   }

   @SuppressWarnings("unchecked")
   public boolean matchCase(Dictionary dictionary)
   {
      return operation.match(PropertySource.fromDictionary(dictionary, true));
   }

   @Override
   public String toString()
   {
      if (cachedString == null)
      {
         StringBuilder builder = new StringBuilder();
         builder.append('(');
         operation.toString(builder);
         builder.append(')');
         cachedString = builder.toString();
      }
      return cachedString;
   }
   
   @Override
   public int hashCode()
   {
      return toString().hashCode();
   }
   
   @Override
   public boolean equals(Object obj)
   {
      if (obj == this)
         return true;
      if (obj == null || obj instanceof Filter == false)
         return false;
      return toString().equals(obj.toString());
   }
}
