/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.osgi.framework.filter.property;

import java.util.Dictionary;

import org.jboss.osgi.framework.util.CaseInsensitiveDictionary;
import org.osgi.framework.ServiceReference;

/**
 * PropertySource.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public abstract class PropertySource
{
   /**
    * Create a property source for a dictionary
    * 
    * @param dictionary the dictionary
    * @param caseSensitive whether the match should be case sensitive
    * @return the property source
    */
   @SuppressWarnings("unchecked")
   public static PropertySource fromDictionary(Dictionary dictionary, boolean caseSensitive)
   {
      if (caseSensitive == false)
         dictionary = new CaseInsensitiveDictionary(dictionary);
      return new DictionaryToPropertySource(dictionary);
   }
   /**
    * Create a property source for a service reference
    * 
    * @param reference the service reference
    * @return the property source
    */
   public static PropertySource fromServiceReference(ServiceReference reference)
   {
      return new ServiceReferenceToPropertySource(reference);
   }
   
   /**
    * Get a property
    * 
    * @param key the key
    * @return the property or null if not found
    */
   public abstract Object getProperty(String key);
}
