/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.framework.launch;

// $Id: OSGiFrameworkBootstrapProvider.java 94263 2009-10-02 10:21:47Z thomas.diesler@jboss.com $

import java.io.InputStream;
import java.net.URL;

import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/**
 * An impementation of an OSGiBootstrapProvider
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Aug-2009
 */
public class OSGiFrameworkBootstrapProvider implements OSGiBootstrapProvider
{
   // Provide logging
   final Logger log = Logger.getLogger(OSGiFrameworkBootstrapProvider.class);

   private Framework framework;
   
   public void configure()
   {
      FrameworkFactory factory = ServiceLoader.loadService(FrameworkFactory.class);
      framework = factory.newFramework(null);
   }

   public void configure(URL urlConfig)
   {
      configure();
   }

   public void configure(String resourceConfig)
   {
      configure();
   }

   public void configure(InputStream streamConfig)
   {
      configure();
   }

   public Framework getFramework()
   {
      return framework;
   }
}